/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.LongGaugeData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

final class LongLastValueAggregator
extends AbstractAggregator<Long> {
    LongLastValueAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor descriptor) {
        super(resource, instrumentationLibraryInfo, descriptor, false);
    }

    @Override
    public AggregatorHandle<Long> createHandle() {
        return new Handle();
    }

    @Override
    public Long accumulateLong(long value) {
        return value;
    }

    @Override
    public Long merge(Long a1, Long a2) {
        return a2;
    }

    @Override
    public MetricData toMetricData(Map<Attributes, Long> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createLongGauge(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), LongGaugeData.create(MetricDataUtils.toLongPointList(accumulationByLabels, 0L, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<Long> {
        @Nullable
        private static final Long DEFAULT_VALUE = null;
        private final AtomicReference<Long> current = new AtomicReference<Long>(DEFAULT_VALUE);

        Handle() {
        }

        @Override
        protected Long doAccumulateThenReset() {
            return this.current.getAndSet(DEFAULT_VALUE);
        }

        @Override
        protected void doRecordLong(long value) {
            this.current.set(value);
        }
    }
}

