/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.EmptyAggregator;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface Aggregator<T> {
    public static Aggregator<Void> empty() {
        return EmptyAggregator.INSTANCE;
    }

    public AggregatorHandle<T> createHandle();

    default public T accumulateLong(long value) {
        throw new UnsupportedOperationException("This aggregator does not support recording long values.");
    }

    default public T accumulateDouble(double value) {
        throw new UnsupportedOperationException("This aggregator does not support recording double values.");
    }

    public T merge(T var1, T var2);

    public boolean isStateful();

    @Nullable
    public MetricData toMetricData(Map<Attributes, T> var1, long var2, long var4, long var6);
}

