/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramData;
import io.opentelemetry.sdk.metrics.data.ExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExplicitBucketHistogramUtils;
import io.opentelemetry.sdk.metrics.internal.aggregator.HistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

final class DoubleHistogramAggregator
extends AbstractAggregator<HistogramAccumulation> {
    private final double[] boundaries;
    private final List<Double> boundaryList;
    private final Supplier<ExemplarReservoir> reservoirSupplier;

    DoubleHistogramAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, MetricDescriptor metricDescriptor, double[] boundaries, boolean stateful, Supplier<ExemplarReservoir> reservoirSupplier) {
        super(resource, instrumentationLibraryInfo, metricDescriptor, stateful);
        this.boundaries = boundaries;
        ArrayList<Double> boundaryList = new ArrayList<Double>(this.boundaries.length);
        for (double v : this.boundaries) {
            boundaryList.add(v);
        }
        this.boundaryList = Collections.unmodifiableList(boundaryList);
        this.reservoirSupplier = reservoirSupplier;
    }

    @Override
    public AggregatorHandle<HistogramAccumulation> createHandle() {
        return new Handle(this.boundaries, this.reservoirSupplier.get());
    }

    @Override
    public final HistogramAccumulation merge(HistogramAccumulation previous, HistogramAccumulation current) {
        long[] mergedCounts = new long[previous.getCounts().length];
        for (int i = 0; i < previous.getCounts().length; ++i) {
            mergedCounts[i] = previous.getCounts()[i] + current.getCounts()[i];
        }
        return HistogramAccumulation.create(previous.getSum() + current.getSum(), mergedCounts, current.getExemplars());
    }

    @Override
    public final MetricData toMetricData(Map<Attributes, HistogramAccumulation> accumulationByLabels, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return MetricData.createDoubleHistogram(this.getResource(), this.getInstrumentationLibraryInfo(), this.getMetricDescriptor().getName(), this.getMetricDescriptor().getDescription(), this.getMetricDescriptor().getUnit(), DoubleHistogramData.create(this.isStateful() ? AggregationTemporality.CUMULATIVE : AggregationTemporality.DELTA, MetricDataUtils.toDoubleHistogramPointList(accumulationByLabels, this.isStateful() ? startEpochNanos : lastCollectionEpoch, epochNanos, this.boundaryList)));
    }

    @Override
    public HistogramAccumulation accumulateDouble(double value) {
        long[] counts = new long[this.boundaries.length + 1];
        counts[ExplicitBucketHistogramUtils.findBucketIndex((double[])this.boundaries, (double)value)] = 1L;
        return HistogramAccumulation.create(value, counts);
    }

    @Override
    public HistogramAccumulation accumulateLong(long value) {
        return this.accumulateDouble(value);
    }

    static final class Handle
    extends AggregatorHandle<HistogramAccumulation> {
        private final double[] boundaries;
        private double sum;
        private final long[] counts;
        private final ReentrantLock lock = new ReentrantLock();

        Handle(double[] boundaries, ExemplarReservoir reservoir) {
            super(reservoir);
            this.boundaries = boundaries;
            this.counts = new long[this.boundaries.length + 1];
            this.sum = 0.0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected HistogramAccumulation doAccumulateThenReset(List<ExemplarData> exemplars) {
            this.lock.lock();
            try {
                HistogramAccumulation acc = HistogramAccumulation.create(this.sum, Arrays.copyOf(this.counts, this.counts.length), exemplars);
                this.sum = 0.0;
                Arrays.fill(this.counts, 0L);
                HistogramAccumulation histogramAccumulation = acc;
                return histogramAccumulation;
            }
            finally {
                this.lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void doRecordDouble(double value) {
            int bucketIndex = ExplicitBucketHistogramUtils.findBucketIndex(this.boundaries, value);
            this.lock.lock();
            try {
                this.sum += value;
                int n = bucketIndex;
                this.counts[n] = this.counts[n] + 1L;
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }
    }
}

