/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.exemplar.ExemplarFilter;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.DefaultSynchronousMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.EmptyMetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorage;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import io.opentelemetry.sdk.metrics.view.View;
import io.opentelemetry.sdk.resources.Resource;

public interface SynchronousMetricStorage
extends MetricStorage,
WriteableMetricStorage {
    public static SynchronousMetricStorage empty() {
        return EmptyMetricStorage.INSTANCE;
    }

    public static <T> SynchronousMetricStorage create(View view, InstrumentDescriptor instrumentDescriptor, Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, ExemplarFilter exemplarFilter) {
        MetricDescriptor metricDescriptor = MetricDescriptor.create(view, instrumentDescriptor);
        Aggregator aggregator = view.getAggregation().createAggregator(resource, instrumentationLibraryInfo, instrumentDescriptor, metricDescriptor, exemplarFilter);
        if (Aggregator.empty() == aggregator) {
            return SynchronousMetricStorage.empty();
        }
        return new DefaultSynchronousMetricStorage(metricDescriptor, aggregator, view.getAttributesProcessor());
    }
}

