/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.BoundLongHistogram;
import io.opentelemetry.api.metrics.DoubleHistogramBuilder;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.LongHistogramBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.SdkDoubleHistogram;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;

final class SdkLongHistogram
extends AbstractInstrument
implements LongHistogram {
    private final WriteableMetricStorage storage;

    private SdkLongHistogram(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    public void record(long value, Attributes attributes, Context context) {
        this.storage.recordLong(value, attributes, context);
    }

    public void record(long value, Attributes attributes) {
        this.record(value, attributes, Context.current());
    }

    public void record(long value) {
        this.record(value, Attributes.empty());
    }

    public BoundLongHistogram bind(Attributes attributes) {
        return new BoundInstrument(this.storage.bind(attributes), attributes);
    }

    static final class BoundInstrument
    implements BoundLongHistogram {
        private final BoundStorageHandle handle;
        private final Attributes attributes;

        BoundInstrument(BoundStorageHandle handle, Attributes attributes) {
            this.handle = handle;
            this.attributes = attributes;
        }

        public void record(long value, Context context) {
            this.handle.recordLong(value, this.attributes, context);
        }

        public void record(long value) {
            this.record(value, Context.current());
        }

        public void unbind() {
            this.handle.release();
        }
    }

    static final class Builder
    extends AbstractInstrumentBuilder<Builder>
    implements LongHistogramBuilder {
        Builder(MeterProviderSharedState meterProviderSharedState, MeterSharedState sharedState, String name, String description, String unit) {
            super(meterProviderSharedState, sharedState, name, description, unit);
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        public SdkLongHistogram build() {
            return this.buildSynchronousInstrument(InstrumentType.HISTOGRAM, InstrumentValueType.LONG, (x$0, x$1) -> new SdkLongHistogram((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        public DoubleHistogramBuilder ofDoubles() {
            return this.swapBuilder(SdkDoubleHistogram.Builder::new);
        }
    }
}

