/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.assertj;

import io.opentelemetry.sdk.testing.assertj.SpanDataAssert;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.assertj.core.api.AbstractIterableAssert;

public final class TraceAssert
extends AbstractIterableAssert<TraceAssert, List<SpanData>, SpanData, SpanDataAssert> {
    TraceAssert(List<SpanData> spanData) {
        super(spanData, TraceAssert.class);
    }

    public TraceAssert hasTraceId(String traceId) {
        this.isNotNull();
        this.isNotEmpty();
        String actualTraceId = ((SpanData)((List)this.actual).get(0)).getTraceId();
        if (!actualTraceId.equals(traceId)) {
            this.failWithActualExpectedAndMessage(actualTraceId, traceId, "Expected trace to have trace ID <%s> but was <%s>", new Object[]{traceId, actualTraceId});
        }
        return this;
    }

    @SafeVarargs
    public final TraceAssert hasSpansSatisfyingExactly(Consumer<SpanDataAssert> ... assertions) {
        return this.hasSpansSatisfyingExactly(Arrays.asList(assertions));
    }

    public TraceAssert hasSpansSatisfyingExactly(Iterable<? extends Consumer<SpanDataAssert>> assertions) {
        List assertionsList = StreamSupport.stream(assertions.spliterator(), false).collect(Collectors.toList());
        this.hasSize(assertionsList.size());
        for (int i = 0; i < assertionsList.size(); ++i) {
            ((Consumer)assertionsList.get(i)).accept(new SpanDataAssert((SpanData)((List)this.actual).get(i)));
        }
        return this;
    }

    public SpanData getSpan(int index) {
        return (SpanData)((List)this.actual).get(index);
    }

    protected SpanDataAssert toAssert(SpanData value, String description) {
        return (SpanDataAssert)((Object)new SpanDataAssert(value).as(description, new Object[0]));
    }

    protected TraceAssert newAbstractIterableAssert(Iterable<? extends SpanData> iterable) {
        return new TraceAssert(StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList()));
    }
}

