/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.exporter;

import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.metrics.export.AggregationTemporalitySelector;
import io.opentelemetry.sdk.metrics.export.DefaultAggregationSelector;
import io.opentelemetry.sdk.testing.exporter.InMemoryMetricReader;

public final class InMemoryMetricReaderBuilder {
    private AggregationTemporalitySelector aggregationTemporalitySelector = AggregationTemporalitySelector.alwaysCumulative();
    private DefaultAggregationSelector defaultAggregationSelector = DefaultAggregationSelector.getDefault();
    private MemoryMode memoryMode = MemoryMode.IMMUTABLE_DATA;

    InMemoryMetricReaderBuilder() {
    }

    public InMemoryMetricReaderBuilder setAggregationTemporalitySelector(AggregationTemporalitySelector aggregationTemporalitySelector) {
        this.aggregationTemporalitySelector = aggregationTemporalitySelector;
        return this;
    }

    public InMemoryMetricReaderBuilder setDefaultAggregationSelector(DefaultAggregationSelector defaultAggregationSelector) {
        this.defaultAggregationSelector = defaultAggregationSelector;
        return this;
    }

    public InMemoryMetricReaderBuilder setMemoryMode(MemoryMode memoryMode) {
        this.memoryMode = memoryMode;
        return this;
    }

    public InMemoryMetricReader build() {
        return new InMemoryMetricReader(this.aggregationTemporalitySelector, this.defaultAggregationSelector, this.memoryMode);
    }
}

