/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.testing.metrics;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.Data;
import io.opentelemetry.sdk.metrics.data.DoublePointData;
import io.opentelemetry.sdk.metrics.data.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.data.GaugeData;
import io.opentelemetry.sdk.metrics.data.HistogramData;
import io.opentelemetry.sdk.metrics.data.LongPointData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.data.MetricDataType;
import io.opentelemetry.sdk.metrics.data.SumData;
import io.opentelemetry.sdk.metrics.data.SummaryData;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.testing.metrics.AutoValue_TestMetricData;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class TestMetricData
implements MetricData {
    public static Builder builder() {
        return new AutoValue_TestMetricData.Builder().setResource(Resource.empty()).setInstrumentationScopeInfo(InstrumentationScopeInfo.empty());
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract TestMetricData autoBuild();

        public TestMetricData build() {
            return this.autoBuild();
        }

        public abstract Builder setResource(Resource var1);

        public abstract Builder setName(String var1);

        public abstract Builder setDescription(String var1);

        public abstract Builder setUnit(String var1);

        abstract Builder setType(MetricDataType var1);

        abstract Builder setData(Data<?> var1);

        public Builder setExponentialHistogramData(ExponentialHistogramData data) {
            return this.setType(MetricDataType.EXPONENTIAL_HISTOGRAM).setData((Data<?>)data);
        }

        public Builder setHistogramData(HistogramData data) {
            return this.setType(MetricDataType.HISTOGRAM).setData((Data<?>)data);
        }

        public Builder setLongSumData(SumData<LongPointData> data) {
            return this.setType(MetricDataType.LONG_SUM).setData((Data<?>)data);
        }

        public Builder setDoubleSumData(SumData<DoublePointData> data) {
            return this.setType(MetricDataType.DOUBLE_SUM).setData((Data<?>)data);
        }

        public Builder setDoubleGaugeData(GaugeData<DoublePointData> data) {
            return this.setType(MetricDataType.DOUBLE_GAUGE).setData((Data<?>)data);
        }

        public Builder setLongGaugeData(GaugeData<LongPointData> data) {
            return this.setType(MetricDataType.LONG_GAUGE).setData((Data<?>)data);
        }

        public Builder setSummaryData(SummaryData data) {
            return this.setType(MetricDataType.SUMMARY).setData((Data<?>)data);
        }

        public abstract Builder setInstrumentationScopeInfo(InstrumentationScopeInfo var1);
    }
}

