/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.SdkSpanBuilder;
import io.opentelemetry.sdk.trace.TracerSharedState;

final class SdkTracer
implements Tracer {
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    SdkTracer(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    public SpanBuilder spanBuilder(String spanName) {
        if (this.sharedState.isStopped()) {
            return Tracer.getDefault().spanBuilder(spanName);
        }
        return new SdkSpanBuilder(spanName, this.instrumentationLibraryInfo, this.sharedState.getActiveSpanProcessor(), this.sharedState.getActiveTraceConfig(), this.sharedState.getResource(), this.sharedState.getIdGenerator(), this.sharedState.getClock());
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

