/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.NoopSpanProcessor;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;

final class TracerSharedState {
    private final Object lock = new Object();
    private final Clock clock;
    private final IdGenerator idGenerator;
    private final Resource resource;
    private volatile TraceConfig activeTraceConfig;
    private volatile SpanProcessor activeSpanProcessor = NoopSpanProcessor.getInstance();
    private volatile boolean isStopped = false;
    @GuardedBy(value="lock")
    private final List<SpanProcessor> registeredSpanProcessors = new ArrayList<SpanProcessor>();

    TracerSharedState(Clock clock, IdGenerator idGenerator, Resource resource, TraceConfig traceConfig) {
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.resource = resource;
        this.activeTraceConfig = traceConfig;
    }

    Clock getClock() {
        return this.clock;
    }

    IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    Resource getResource() {
        return this.resource;
    }

    TraceConfig getActiveTraceConfig() {
        return this.activeTraceConfig;
    }

    void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.activeTraceConfig = traceConfig;
    }

    SpanProcessor getActiveSpanProcessor() {
        return this.activeSpanProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpanProcessor(SpanProcessor spanProcessor) {
        Object object = this.lock;
        synchronized (object) {
            this.registeredSpanProcessors.add(spanProcessor);
            this.activeSpanProcessor = SpanProcessor.composite(this.registeredSpanProcessors);
        }
    }

    boolean isStopped() {
        return this.isStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.lock;
        synchronized (object) {
            if (this.isStopped) {
                return;
            }
            this.activeSpanProcessor.shutdown().join(10L, TimeUnit.SECONDS);
            this.isStopped = true;
        }
    }
}

