/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.trace.config.AutoValue_TraceConfig;
import io.opentelemetry.sdk.trace.config.TraceConfigBuilder;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfig {
    public static final int UNLIMITED_ATTRIBUTE_LENGTH = -1;
    private static final TraceConfig DEFAULT = new TraceConfigBuilder().build();

    public static TraceConfig getDefault() {
        return DEFAULT;
    }

    static TraceConfig create(Sampler sampler, int maxNumAttributes, int maxNumEvents, int maxNumLinks, int maxNumAttributesPerEvent, int maxNumAttributesPerLink, int maxAttributeLength) {
        return new AutoValue_TraceConfig(sampler, maxNumAttributes, maxNumEvents, maxNumLinks, maxNumAttributesPerEvent, maxNumAttributesPerLink, maxAttributeLength);
    }

    public abstract Sampler getSampler();

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfEvents();

    public abstract int getMaxNumberOfLinks();

    public abstract int getMaxNumberOfAttributesPerEvent();

    public abstract int getMaxNumberOfAttributesPerLink();

    public abstract int getMaxLengthOfAttributeValues();

    public boolean shouldTruncateStringAttributeValues() {
        return this.getMaxLengthOfAttributeValues() != -1;
    }

    public TraceConfigBuilder toBuilder() {
        return new TraceConfigBuilder().setSampler(this.getSampler()).setMaxNumberOfAttributes(this.getMaxNumberOfAttributes()).setMaxNumberOfEvents(this.getMaxNumberOfEvents()).setMaxNumberOfLinks(this.getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent(this.getMaxNumberOfAttributesPerEvent()).setMaxNumberOfAttributesPerLink(this.getMaxNumberOfAttributesPerLink()).setMaxLengthOfAttributeValues(this.getMaxLengthOfAttributeValues());
    }
}

