/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.internal.SystemClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;

public final class SdkTracerProviderBuilder {
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = SystemClock.getInstance();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<TraceConfig> traceConfigSupplier = TraceConfig::getDefault;

    public SdkTracerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder setTraceConfig(TraceConfig traceConfig) {
        Objects.requireNonNull(traceConfig, "traceConfig");
        this.traceConfigSupplier = () -> traceConfig;
        return this;
    }

    public SdkTracerProviderBuilder setTraceConfig(Supplier<TraceConfig> traceConfigSupplier) {
        Objects.requireNonNull(traceConfigSupplier, "traceConfig");
        this.traceConfigSupplier = traceConfigSupplier;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.traceConfigSupplier, this.spanProcessors);
    }

    SdkTracerProviderBuilder() {
    }
}

