/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;

public final class TraceConfigBuilder
extends ConfigBuilder<TraceConfigBuilder> {
    private static final String KEY_SAMPLER_PROBABILITY = "otel.config.sampler.probability";
    private static final String KEY_SPAN_ATTRIBUTE_COUNT_LIMIT = "otel.span.attribute.count.limit";
    private static final String KEY_SPAN_EVENT_COUNT_LIMIT = "otel.span.event.count.limit";
    private static final String KEY_SPAN_LINK_COUNT_LIMIT = "otel.span.link.count.limit";
    private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = "otel.config.max.event.attrs";
    private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = "otel.config.max.link.attrs";
    private static final String KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH = "otel.config.max.attr.length";
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 1000;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 32;
    private static final int DEFAULT_MAX_ATTRIBUTE_LENGTH = -1;
    private Sampler sampler = DEFAULT_SAMPLER;
    private int maxNumAttributes = 1000;
    private int maxNumEvents = 1000;
    private int maxNumLinks = 1000;
    private int maxNumAttributesPerEvent = 32;
    private int maxNumAttributesPerLink = 32;
    private int maxAttributeLength = -1;

    TraceConfigBuilder() {
    }

    protected TraceConfigBuilder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
        Integer intValue;
        Double doubleValue = TraceConfigBuilder.getDoubleProperty((String)KEY_SAMPLER_PROBABILITY, (Map)(configMap = namingConvention.normalize(configMap)));
        if (doubleValue != null) {
            this.setTraceIdRatioBased(doubleValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_ATTRIBUTE_COUNT_LIMIT, (Map)configMap)) != null) {
            this.setMaxNumberOfAttributes(intValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_EVENT_COUNT_LIMIT, (Map)configMap)) != null) {
            this.setMaxNumberOfEvents(intValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_LINK_COUNT_LIMIT, (Map)configMap)) != null) {
            this.setMaxNumberOfLinks(intValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT, (Map)configMap)) != null) {
            this.setMaxNumberOfAttributesPerEvent(intValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK, (Map)configMap)) != null) {
            this.setMaxNumberOfAttributesPerLink(intValue);
        }
        if ((intValue = TraceConfigBuilder.getIntProperty((String)KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH, (Map)configMap)) != null) {
            this.setMaxLengthOfAttributeValues(intValue);
        }
        return this;
    }

    public TraceConfigBuilder readProperties(Properties properties) {
        return (TraceConfigBuilder)((Object)super.readProperties(properties));
    }

    public TraceConfigBuilder readEnvironmentVariables() {
        return (TraceConfigBuilder)((Object)super.readEnvironmentVariables());
    }

    public TraceConfigBuilder readSystemProperties() {
        return (TraceConfigBuilder)((Object)super.readSystemProperties());
    }

    public TraceConfigBuilder setSampler(Sampler sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.sampler = sampler;
        return this;
    }

    public TraceConfigBuilder setTraceIdRatioBased(double samplerRatio) {
        Utils.checkArgument((samplerRatio >= 0.0 ? 1 : 0) != 0, (String)"samplerRatio must be greater than or equal to 0.");
        Utils.checkArgument((samplerRatio <= 1.0 ? 1 : 0) != 0, (String)"samplerRatio must be lesser than or equal to 1.");
        if (samplerRatio == 1.0) {
            this.setSampler(Sampler.parentBased(Sampler.alwaysOn()));
        } else if (samplerRatio == 0.0) {
            this.setSampler(Sampler.alwaysOff());
        } else {
            this.setSampler(Sampler.parentBased(Sampler.traceIdRatioBased(samplerRatio)));
        }
        return this;
    }

    public TraceConfigBuilder setMaxNumberOfAttributes(int maxNumberOfAttributes) {
        Utils.checkArgument((maxNumberOfAttributes > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributes must be greater than 0");
        this.maxNumAttributes = maxNumberOfAttributes;
        return this;
    }

    public TraceConfigBuilder setMaxNumberOfEvents(int maxNumberOfEvents) {
        Utils.checkArgument((maxNumberOfEvents > 0 ? 1 : 0) != 0, (String)"maxNumberOfEvents must be greater than 0");
        this.maxNumEvents = maxNumberOfEvents;
        return this;
    }

    public TraceConfigBuilder setMaxNumberOfLinks(int maxNumberOfLinks) {
        Utils.checkArgument((maxNumberOfLinks > 0 ? 1 : 0) != 0, (String)"maxNumberOfLinks must be greater than 0");
        this.maxNumLinks = maxNumberOfLinks;
        return this;
    }

    public TraceConfigBuilder setMaxNumberOfAttributesPerEvent(int maxNumberOfAttributesPerEvent) {
        Utils.checkArgument((maxNumberOfAttributesPerEvent > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerEvent must be greater than 0");
        this.maxNumAttributesPerEvent = maxNumberOfAttributesPerEvent;
        return this;
    }

    public TraceConfigBuilder setMaxNumberOfAttributesPerLink(int maxNumberOfAttributesPerLink) {
        Utils.checkArgument((maxNumberOfAttributesPerLink > 0 ? 1 : 0) != 0, (String)"maxNumberOfAttributesPerLink must be greater than 0");
        this.maxNumAttributesPerLink = maxNumberOfAttributesPerLink;
        return this;
    }

    public TraceConfigBuilder setMaxLengthOfAttributeValues(int maxLengthOfAttributeValues) {
        Utils.checkArgument((maxLengthOfAttributeValues == -1 || maxLengthOfAttributeValues > 0 ? 1 : 0) != 0, (String)"maxLengthOfAttributeValues must be -1 to disable length restriction, or positive to enable length restriction");
        this.maxAttributeLength = maxLengthOfAttributeValues;
        return this;
    }

    public TraceConfig build() {
        return TraceConfig.create(this.sampler, this.maxNumAttributes, this.maxNumEvents, this.maxNumLinks, this.maxNumAttributesPerEvent, this.maxNumAttributesPerLink, this.maxAttributeLength);
    }
}

