/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracer;
import io.opentelemetry.sdk.trace.SdkTracerManagement;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkTracerProvider
implements TracerProvider,
SdkTracerManagement {
    private static final Logger logger = Logger.getLogger(SdkTracerProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "unknown";
    private final TracerSharedState sharedState;
    private final ComponentRegistry<SdkTracer> tracerSdkComponentRegistry;

    public static SdkTracerProviderBuilder builder() {
        return new SdkTracerProviderBuilder();
    }

    SdkTracerProvider(Clock clock, IdGenerator idsGenerator, Resource resource, Supplier<TraceConfig> traceConfigSupplier, List<SpanProcessor> spanProcessors) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource, traceConfigSupplier, spanProcessors);
        this.tracerSdkComponentRegistry = new ComponentRegistry(instrumentationLibraryInfo -> new SdkTracer(this.sharedState, (InstrumentationLibraryInfo)instrumentationLibraryInfo));
    }

    public Tracer get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public Tracer get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation name.");
            instrumentationName = DEFAULT_TRACER_NAME;
        }
        return (Tracer)this.tracerSdkComponentRegistry.get(instrumentationName, instrumentationVersion);
    }

    @Override
    public TraceConfig getActiveTraceConfig() {
        return this.sharedState.getActiveTraceConfig();
    }

    @Override
    @Deprecated
    public void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.sharedState.updateActiveTraceConfig(traceConfig);
    }

    @Override
    @Deprecated
    public void addSpanProcessor(SpanProcessor spanProcessor) {
        this.sharedState.addSpanProcessor(spanProcessor);
    }

    @Override
    public CompletableResultCode shutdown() {
        if (this.sharedState.isStopped()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }
}

