/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class TracerSharedState {
    private final Object lock = new Object();
    private final Clock clock;
    private final IdGenerator idGenerator;
    private final Resource resource;
    private volatile Supplier<TraceConfig> traceConfigSupplier;
    private volatile SpanProcessor activeSpanProcessor;
    @Nullable
    @GuardedBy(value="lock")
    private volatile CompletableResultCode shutdownResult = null;
    @GuardedBy(value="lock")
    private final List<SpanProcessor> registeredSpanProcessors;

    TracerSharedState(Clock clock, IdGenerator idGenerator, Resource resource, Supplier<TraceConfig> traceConfigSupplier, List<SpanProcessor> spanProcessors) {
        this.clock = clock;
        this.idGenerator = idGenerator;
        this.resource = resource;
        this.traceConfigSupplier = traceConfigSupplier;
        this.registeredSpanProcessors = new ArrayList<SpanProcessor>(spanProcessors);
        this.activeSpanProcessor = SpanProcessor.composite(this.registeredSpanProcessors);
    }

    Clock getClock() {
        return this.clock;
    }

    IdGenerator getIdGenerator() {
        return this.idGenerator;
    }

    Resource getResource() {
        return this.resource;
    }

    TraceConfig getActiveTraceConfig() {
        return this.traceConfigSupplier.get();
    }

    void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.traceConfigSupplier = () -> traceConfig;
    }

    SpanProcessor getActiveSpanProcessor() {
        return this.activeSpanProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addSpanProcessor(SpanProcessor spanProcessor) {
        Object object = this.lock;
        synchronized (object) {
            this.registeredSpanProcessors.add(spanProcessor);
            this.activeSpanProcessor = SpanProcessor.composite(this.registeredSpanProcessors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isStopped() {
        Object object = this.lock;
        synchronized (object) {
            return this.shutdownResult != null && this.shutdownResult.isSuccess();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CompletableResultCode shutdown() {
        Object object = this.lock;
        synchronized (object) {
            if (this.shutdownResult != null) {
                return this.shutdownResult;
            }
            this.shutdownResult = this.activeSpanProcessor.shutdown();
            return this.shutdownResult;
        }
    }
}

