/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.samplers;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TraceId;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.AutoValue_TraceIdRatioBasedSampler;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
abstract class TraceIdRatioBasedSampler
implements Sampler {
    TraceIdRatioBasedSampler() {
    }

    static TraceIdRatioBasedSampler create(double ratio) {
        if (ratio < 0.0 || ratio > 1.0) {
            throw new IllegalArgumentException("ratio must be in range [0.0, 1.0]");
        }
        long idUpperBound = ratio == 0.0 ? Long.MIN_VALUE : (ratio == 1.0 ? Long.MAX_VALUE : (long)(ratio * 9.223372036854776E18));
        return new AutoValue_TraceIdRatioBasedSampler(ratio, idUpperBound, SamplingResult.create(SamplingResult.Decision.RECORD_AND_SAMPLE), SamplingResult.create(SamplingResult.Decision.DROP));
    }

    abstract double getRatio();

    abstract long getIdUpperBound();

    abstract SamplingResult getPositiveSamplingResult();

    abstract SamplingResult getNegativeSamplingResult();

    @Override
    public final SamplingResult shouldSample(Context parentContext, String traceId, String name, Span.Kind spanKind, Attributes attributes, List<LinkData> parentLinks) {
        return Math.abs(TraceId.getTraceIdRandomPart((CharSequence)traceId)) < this.getIdUpperBound() ? this.getPositiveSamplingResult() : this.getNegativeSamplingResult();
    }

    @Override
    public final String getDescription() {
        return String.format("TraceIdRatioBased{%.6f}", this.getRatio());
    }

    public final String toString() {
        return this.getDescription();
    }
}

