/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.MonotonicClock;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.StringUtils;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SdkSpanBuilder
implements SpanBuilder {
    private final String spanName;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final TracerSharedState tracerSharedState;
    private final TraceConfig traceConfig;
    @Nullable
    private Context parent;
    private Span.Kind spanKind = Span.Kind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<LinkData> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;
    private boolean isRootSpan;

    SdkSpanBuilder(String spanName, InstrumentationLibraryInfo instrumentationLibraryInfo, TracerSharedState tracerSharedState, TraceConfig traceConfig) {
        this.spanName = spanName;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.tracerSharedState = tracerSharedState;
        this.traceConfig = traceConfig;
    }

    public SpanBuilder setParent(Context context) {
        Objects.requireNonNull(context, "context");
        this.isRootSpan = false;
        this.parent = context;
        return this;
    }

    public SpanBuilder setNoParent() {
        this.isRootSpan = true;
        this.parent = null;
        return this;
    }

    public SpanBuilder setSpanKind(Span.Kind spanKind) {
        this.spanKind = Objects.requireNonNull(spanKind, "spanKind");
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        this.addLink(LinkData.create(spanContext));
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        int totalAttributeCount = attributes.size();
        this.addLink(LinkData.create(spanContext, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerLink()), totalAttributeCount));
        return this;
    }

    private void addLink(LinkData link) {
        Objects.requireNonNull(link, "link");
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<LinkData>(this.traceConfig.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.traceConfig.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(link);
    }

    public SpanBuilder setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey((String)key), value);
    }

    public SpanBuilder setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
        }
        if (this.traceConfig.shouldTruncateStringAttributeValues()) {
            value = StringUtils.truncateToSize(key, value, this.traceConfig.getMaxLengthOfAttributeValues());
        }
        this.attributes.put(key, value);
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        Utils.checkArgument((startTimestamp >= 0L ? 1 : 0) != 0, (String)"Negative startTimestamp");
        this.startEpochNanos = unit.toNanos(startTimestamp);
        return this;
    }

    public Span startSpan() {
        Context parentContext = this.isRootSpan ? Context.root() : (this.parent == null ? Context.current() : this.parent);
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        IdGenerator idGenerator = this.tracerSharedState.getIdGenerator();
        String spanId = idGenerator.generateSpanId();
        String traceId = !parentSpanContext.isValid() ? idGenerator.generateTraceId() : parentSpanContext.getTraceIdAsHexString();
        List<LinkData> immutableLinks = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Attributes immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        SamplingResult samplingResult = this.tracerSharedState.getSampler().shouldSample(parentContext, traceId, this.spanName, this.spanKind, immutableAttributes, immutableLinks);
        SamplingDecision samplingDecision = samplingResult.getDecision();
        TraceState samplingResultTraceState = samplingResult.getUpdatedTraceState(parentSpanContext.getTraceState());
        SpanContext spanContext = SdkSpanBuilder.createSpanContext(traceId, spanId, samplingResultTraceState, SdkSpanBuilder.isSampled(samplingDecision));
        if (!SdkSpanBuilder.isRecording(samplingDecision)) {
            return Span.wrap((SpanContext)spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
            }
            samplingAttributes.forEach((key, value) -> this.attributes.put(key, value));
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return RecordEventsReadableSpan.startSpan(spanContext, this.spanName, this.instrumentationLibraryInfo, this.spanKind, parentSpanContext, parentContext, this.traceConfig, this.tracerSharedState.getActiveSpanProcessor(), SdkSpanBuilder.getClock(parentSpan, this.tracerSharedState.getClock()), this.tracerSharedState.getResource(), recordedAttributes, immutableLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private static SpanContext createSpanContext(String traceId, String spanId, TraceState traceState, boolean isSampled) {
        byte traceFlags = isSampled ? TraceFlags.getSampled() : TraceFlags.getDefault();
        return SpanContext.create((String)traceId, (String)spanId, (byte)traceFlags, (TraceState)traceState);
    }

    private static Clock getClock(Span parent, Clock clock) {
        if (parent instanceof RecordEventsReadableSpan) {
            RecordEventsReadableSpan parentRecordEventsSpan = (RecordEventsReadableSpan)parent;
            return parentRecordEventsSpan.getClock();
        }
        return MonotonicClock.create((Clock)clock);
    }

    static boolean isRecording(SamplingDecision decision) {
        return SamplingDecision.RECORD_ONLY.equals((Object)decision) || SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    static boolean isSampled(SamplingDecision decision) {
        return SamplingDecision.RECORD_AND_SAMPLE.equals((Object)decision);
    }
}

