/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.sdk.trace.AutoValue_SpanLimits;
import io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class SpanLimits {
    public static final int UNLIMITED_ATTRIBUTE_LENGTH = -1;
    private static final SpanLimits DEFAULT = new SpanLimitsBuilder().build();

    public static SpanLimits getDefault() {
        return DEFAULT;
    }

    public static SpanLimitsBuilder builder() {
        return new SpanLimitsBuilder();
    }

    static SpanLimits create(int maxNumAttributes, int maxNumEvents, int maxNumLinks, int maxNumAttributesPerEvent, int maxNumAttributesPerLink, int maxAttributeLength) {
        return new AutoValue_SpanLimits(maxNumAttributes, maxNumEvents, maxNumLinks, maxNumAttributesPerEvent, maxNumAttributesPerLink, maxAttributeLength);
    }

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfEvents();

    public abstract int getMaxNumberOfLinks();

    public abstract int getMaxNumberOfAttributesPerEvent();

    public abstract int getMaxNumberOfAttributesPerLink();

    public abstract int getMaxLengthOfAttributeValues();

    public boolean shouldTruncateStringAttributeValues() {
        return this.getMaxLengthOfAttributeValues() != -1;
    }

    public SpanLimitsBuilder toBuilder() {
        return new SpanLimitsBuilder().setMaxNumberOfAttributes(this.getMaxNumberOfAttributes()).setMaxNumberOfEvents(this.getMaxNumberOfEvents()).setMaxNumberOfLinks(this.getMaxNumberOfLinks()).setMaxNumberOfAttributesPerEvent(this.getMaxNumberOfAttributesPerEvent()).setMaxNumberOfAttributesPerLink(this.getMaxNumberOfAttributesPerLink()).setMaxLengthOfAttributeValues(this.getMaxLengthOfAttributeValues());
    }
}

