/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AnchoredClock;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.SpanWrapper;
import io.opentelemetry.sdk.trace.data.EventData;
import io.opentelemetry.sdk.trace.data.LinkData;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.data.StatusData;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class RecordEventsReadableSpan
implements ReadWriteSpan {
    private static final Logger logger = Logger.getLogger(RecordEventsReadableSpan.class.getName());
    private final SpanLimits spanLimits;
    private final SpanContext context;
    private final SpanContext parentSpanContext;
    private final SpanProcessor spanProcessor;
    private final List<LinkData> links;
    private final int totalRecordedLinks;
    private final SpanKind kind;
    private final AnchoredClock clock;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final long startEpochNanos;
    private final Object lock = new Object();
    private String name;
    @Nullable
    private AttributesMap attributes;
    private final List<EventData> events;
    private int totalRecordedEvents = 0;
    @Nullable
    private StatusData status = StatusData.unset();
    private long endEpochNanos;
    private boolean hasEnded;

    private RecordEventsReadableSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanKind kind, SpanContext parentSpanContext, SpanLimits spanLimits, SpanProcessor spanProcessor, AnchoredClock clock, Resource resource, @Nullable AttributesMap attributes, List<LinkData> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.parentSpanContext = parentSpanContext;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = false;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = attributes;
        this.events = new ArrayList<EventData>();
        this.spanLimits = spanLimits;
    }

    static RecordEventsReadableSpan startSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanKind kind, @Nullable SpanContext parentSpanContext, @Nonnull Context parentContext, SpanLimits spanLimits, SpanProcessor spanProcessor, AnchoredClock clock, Resource resource, AttributesMap attributes, List<LinkData> links, int totalRecordedLinks, long startEpochNanos) {
        RecordEventsReadableSpan span = new RecordEventsReadableSpan(context, name, instrumentationLibraryInfo, kind, parentSpanContext, spanLimits, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos == 0L ? clock.now() : startEpochNanos);
        spanProcessor.onStart(parentContext, span);
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.links, this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.getSpanDataStatus(), this.name, this.endEpochNanos, this.hasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded ? this.endEpochNanos : this.clock.now()) - this.startEpochNanos;
        }
    }

    AnchoredClock getClock() {
        return this.clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> ReadWriteSpan setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey().isEmpty() || value == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setAttribute() on an ended Span.");
                return this;
            }
            if (this.attributes == null) {
                this.attributes = new AttributesMap((long)this.spanLimits.getMaxNumberOfAttributes());
            }
            this.attributes.put(key, value);
        }
        return this;
    }

    public ReadWriteSpan addEvent(String name) {
        if (name == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(this.clock.now(), name, Attributes.empty(), 0));
        return this;
    }

    public ReadWriteSpan addEvent(String name, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, Attributes.empty(), 0));
        return this;
    }

    public ReadWriteSpan addEvent(String name, Attributes attributes) {
        if (name == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(this.clock.now(), name, RecordEventsReadableSpan.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
        return this;
    }

    public ReadWriteSpan addEvent(String name, Attributes attributes, long timestamp, TimeUnit unit) {
        if (name == null || unit == null) {
            return this;
        }
        if (attributes == null) {
            attributes = Attributes.empty();
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(EventData.create(unit.toNanos(timestamp), name, RecordEventsReadableSpan.applyAttributesLimit(attributes, this.spanLimits.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
        return this;
    }

    static Attributes applyAttributesLimit(Attributes attributes, int limit) {
        if (attributes.isEmpty() || attributes.size() <= limit) {
            return attributes;
        }
        AttributesBuilder result = Attributes.builder();
        int i = 0;
        for (Map.Entry entry : attributes.asMap().entrySet()) {
            if (i >= limit) break;
            result.put((AttributeKey)entry.getKey(), entry.getValue());
            ++i;
        }
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(EventData timedEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling addEvent() on an ended Span.");
                return;
            }
            if (this.events.size() < this.spanLimits.getMaxNumberOfEvents()) {
                this.events.add(timedEvent);
            }
            ++this.totalRecordedEvents;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWriteSpan setStatus(StatusCode statusCode, @Nullable String description) {
        if (statusCode == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return this;
            }
            this.status = StatusData.create(statusCode, description);
        }
        return this;
    }

    public ReadWriteSpan recordException(Throwable exception) {
        this.recordException(exception, null);
        return this;
    }

    public ReadWriteSpan recordException(Throwable exception, Attributes additionalAttributes) {
        if (exception == null) {
            return this;
        }
        long timestampNanos = this.clock.now();
        AttributesBuilder attributes = Attributes.builder();
        attributes.put(SemanticAttributes.EXCEPTION_TYPE, (Object)exception.getClass().getCanonicalName());
        if (exception.getMessage() != null) {
            attributes.put(SemanticAttributes.EXCEPTION_MESSAGE, (Object)exception.getMessage());
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        attributes.put(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
        if (additionalAttributes != null) {
            attributes.putAll(additionalAttributes);
        }
        this.addEvent("exception", attributes.build(), timestampNanos, TimeUnit.NANOSECONDS);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWriteSpan updateName(String name) {
        if (name == null) {
            return this;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling updateName() on an ended Span.");
                return this;
            }
            this.name = name;
        }
        return this;
    }

    public void end() {
        this.endInternal(this.clock.now());
    }

    public void end(long timestamp, TimeUnit unit) {
        if (unit == null) {
            unit = TimeUnit.NANOSECONDS;
        }
        this.endInternal(timestamp == 0L ? this.clock.now() : unit.toNanos(timestamp));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.hasEnded = true;
        }
        this.spanProcessor.onEnd(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRecording() {
        Object object = this.lock;
        synchronized (object) {
            return !this.hasEnded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StatusData getSpanDataStatus() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    SpanContext getParentSpanContext() {
        return this.parentSpanContext;
    }

    Resource getResource() {
        return this.resource;
    }

    @Override
    public SpanKind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    int getTotalRecordedLinks() {
        return this.totalRecordedLinks;
    }

    private List<EventData> getImmutableTimedEvents() {
        if (this.events.isEmpty()) {
            return Collections.emptyList();
        }
        if (this.hasEnded) {
            return Collections.unmodifiableList(this.events);
        }
        return Collections.unmodifiableList(new ArrayList<EventData>(this.events));
    }

    private Attributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded) {
            return this.attributes;
        }
        return this.attributes.immutableCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long endEpochNanos;
        long totalRecordedEvents;
        String status;
        String attributes;
        String name;
        Object object = this.lock;
        synchronized (object) {
            name = this.name;
            attributes = String.valueOf(this.attributes);
            status = String.valueOf(this.status);
            totalRecordedEvents = this.totalRecordedEvents;
            endEpochNanos = this.endEpochNanos;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("RecordEventsReadableSpan{traceId=");
        sb.append(this.context.getTraceId());
        sb.append(", spanId=");
        sb.append(this.context.getSpanId());
        sb.append(", parentSpanContext=");
        sb.append(this.parentSpanContext);
        sb.append(", name=");
        sb.append(name);
        sb.append(", kind=");
        sb.append(this.kind);
        sb.append(", attributes=");
        sb.append(attributes);
        sb.append(", status=");
        sb.append(status);
        sb.append(", totalRecordedEvents=");
        sb.append(totalRecordedEvents);
        sb.append(", totalRecordedLinks=");
        sb.append(this.totalRecordedLinks);
        sb.append(", startEpochNanos=");
        sb.append(this.startEpochNanos);
        sb.append(", endEpochNanos=");
        sb.append(endEpochNanos);
        sb.append("}");
        return sb.toString();
    }
}

