/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.ReadableAttributes;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;

final class AttributesMap
implements ReadableAttributes {
    private final Map<AttributeKey, Object> data;
    private final long capacity;
    private int totalAddedValues = 0;

    private AttributesMap(long capacity, Map<AttributeKey, Object> data) {
        this.capacity = capacity;
        this.data = data;
    }

    AttributesMap(long capacity) {
        this(capacity, new LinkedHashMap<AttributeKey, Object>());
    }

    public <T> void put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || value == null) {
            return;
        }
        ++this.totalAddedValues;
        if ((long)this.data.size() >= this.capacity && !this.data.containsKey(key)) {
            return;
        }
        this.data.put(key, value);
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    public <T> T get(AttributeKey<T> key) {
        return (T)this.data.get(key);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void forEach(AttributeConsumer consumer) {
        for (Map.Entry<AttributeKey, Object> entry : this.data.entrySet()) {
            AttributeKey key = entry.getKey();
            Object value = entry.getValue();
            consumer.accept(key, value);
        }
    }

    public String toString() {
        return "AttributesMap{data=" + this.data + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    ReadableAttributes immutableCopy() {
        LinkedHashMap<AttributeKey, Object> dataCopy = new LinkedHashMap<AttributeKey, Object>(this.data);
        return new AttributesMap(this.capacity, Collections.unmodifiableMap(dataCopy));
    }
}

