/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.common.annotations.VisibleForTesting;
import io.opentelemetry.api.common.AttributeConsumer;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceFlags;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.MonotonicClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.StringUtils;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.samplers.SamplingResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class SpanBuilderSdk
implements SpanBuilder {
    private final String spanName;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final SpanProcessor spanProcessor;
    private final TraceConfig traceConfig;
    private final Resource resource;
    private final IdGenerator idsGenerator;
    private final Clock clock;
    @Nullable
    private Context parent;
    private Span.Kind spanKind = Span.Kind.INTERNAL;
    @Nullable
    private AttributesMap attributes;
    @Nullable
    private List<SpanData.Link> links;
    private int totalNumberOfLinksAdded = 0;
    private long startEpochNanos = 0L;
    private boolean isRootSpan;

    SpanBuilderSdk(String spanName, InstrumentationLibraryInfo instrumentationLibraryInfo, SpanProcessor spanProcessor, TraceConfig traceConfig, Resource resource, IdGenerator idsGenerator, Clock clock) {
        this.spanName = spanName;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.spanProcessor = spanProcessor;
        this.traceConfig = traceConfig;
        this.resource = resource;
        this.idsGenerator = idsGenerator;
        this.clock = clock;
    }

    public SpanBuilder setParent(Context context) {
        Objects.requireNonNull(context, "context");
        this.isRootSpan = false;
        this.parent = context;
        return this;
    }

    public SpanBuilder setNoParent() {
        this.isRootSpan = true;
        this.parent = null;
        return this;
    }

    public SpanBuilder setSpanKind(Span.Kind spanKind) {
        this.spanKind = Objects.requireNonNull(spanKind, "spanKind");
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext) {
        this.addLink(SpanData.Link.create(spanContext));
        return this;
    }

    public SpanBuilder addLink(SpanContext spanContext, Attributes attributes) {
        int totalAttributeCount = attributes.size();
        this.addLink(SpanData.Link.create(spanContext, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerLink()), totalAttributeCount));
        return this;
    }

    private void addLink(SpanData.Link link) {
        Objects.requireNonNull(link, "link");
        ++this.totalNumberOfLinksAdded;
        if (this.links == null) {
            this.links = new ArrayList<SpanData.Link>(this.traceConfig.getMaxNumberOfLinks());
        }
        if (this.links.size() == this.traceConfig.getMaxNumberOfLinks()) {
            return;
        }
        this.links.add(link);
    }

    public SpanBuilder setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey((String)key), value);
    }

    public SpanBuilder setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public SpanBuilder setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    public <T> SpanBuilder setAttribute(AttributeKey<T> key, T value) {
        Objects.requireNonNull(key, "key");
        if (value == null) {
            return this;
        }
        if (this.attributes == null) {
            this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
        }
        if (this.traceConfig.shouldTruncateStringAttributeValues()) {
            value = StringUtils.truncateToSize(key, value, this.traceConfig.getMaxLengthOfAttributeValues());
        }
        this.attributes.put(key, value);
        return this;
    }

    public SpanBuilder setStartTimestamp(long startTimestamp, TimeUnit unit) {
        Utils.checkArgument((startTimestamp >= 0L ? 1 : 0) != 0, (String)"Negative startTimestamp");
        this.startEpochNanos = unit.toNanos(startTimestamp);
        return this;
    }

    public Span startSpan() {
        Context parentContext = this.isRootSpan ? Context.root() : (this.parent == null ? Context.current() : this.parent);
        Span parentSpan = Span.fromContext((Context)parentContext);
        SpanContext parentSpanContext = parentSpan.getSpanContext();
        String spanId = this.idsGenerator.generateSpanId();
        String traceId = !parentSpanContext.isValid() ? this.idsGenerator.generateTraceId() : parentSpanContext.getTraceIdAsHexString();
        List<SpanData.Link> immutableLinks = this.links == null ? Collections.emptyList() : Collections.unmodifiableList(this.links);
        this.links = null;
        Object immutableAttributes = this.attributes == null ? Attributes.empty() : this.attributes;
        SamplingResult samplingResult = this.traceConfig.getSampler().shouldSample(parentContext, traceId, this.spanName, this.spanKind, (ReadableAttributes)immutableAttributes, immutableLinks);
        SamplingResult.Decision samplingDecision = samplingResult.getDecision();
        TraceState samplingResultTraceState = samplingResult.getUpdatedTraceState(parentSpanContext.getTraceState());
        SpanContext spanContext = SpanBuilderSdk.createSpanContext(traceId, spanId, samplingResultTraceState, SpanBuilderSdk.isSampled(samplingDecision));
        if (!SpanBuilderSdk.isRecording(samplingDecision)) {
            return Span.wrap((SpanContext)spanContext);
        }
        Attributes samplingAttributes = samplingResult.getAttributes();
        if (!samplingAttributes.isEmpty()) {
            if (this.attributes == null) {
                this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
            }
            samplingAttributes.forEach(new AttributeConsumer(){

                public <T> void accept(AttributeKey<T> key, T value) {
                    SpanBuilderSdk.this.attributes.put(key, value);
                }
            });
        }
        AttributesMap recordedAttributes = this.attributes;
        this.attributes = null;
        return RecordEventsReadableSpan.startSpan(spanContext, this.spanName, this.instrumentationLibraryInfo, this.spanKind, parentSpanContext.getSpanIdAsHexString(), parentSpanContext.isRemote(), parentContext, this.traceConfig, this.spanProcessor, SpanBuilderSdk.getClock(parentSpan, this.clock), this.resource, recordedAttributes, immutableLinks, this.totalNumberOfLinksAdded, this.startEpochNanos);
    }

    private static SpanContext createSpanContext(String traceId, String spanId, TraceState traceState, boolean isSampled) {
        byte traceFlags = isSampled ? TraceFlags.getSampled() : TraceFlags.getDefault();
        return SpanContext.create((String)traceId, (String)spanId, (byte)traceFlags, (TraceState)traceState);
    }

    private static Clock getClock(Span parent, Clock clock) {
        if (parent instanceof RecordEventsReadableSpan) {
            RecordEventsReadableSpan parentRecordEventsSpan = (RecordEventsReadableSpan)parent;
            return parentRecordEventsSpan.getClock();
        }
        return MonotonicClock.create((Clock)clock);
    }

    @VisibleForTesting
    static boolean isRecording(SamplingResult.Decision decision) {
        return SamplingResult.Decision.RECORD_ONLY.equals((Object)decision) || SamplingResult.Decision.RECORD_AND_SAMPLE.equals((Object)decision);
    }

    @VisibleForTesting
    static boolean isSampled(SamplingResult.Decision decision) {
        return SamplingResult.Decision.RECORD_AND_SAMPLE.equals((Object)decision);
    }
}

