/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.ReadableAttributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AutoValue_SpanWrapper;
import io.opentelemetry.sdk.trace.RecordEventsReadableSpan;
import io.opentelemetry.sdk.trace.data.SpanData;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
abstract class SpanWrapper
implements SpanData {
    SpanWrapper() {
    }

    abstract RecordEventsReadableSpan delegate();

    abstract List<SpanData.Link> resolvedLinks();

    abstract List<SpanData.Event> resolvedEvents();

    abstract ReadableAttributes attributes();

    abstract int totalAttributeCount();

    abstract int totalRecordedEvents();

    abstract SpanData.Status status();

    abstract String name();

    abstract long endEpochNanos();

    abstract boolean internalHasEnded();

    static SpanWrapper create(RecordEventsReadableSpan delegate, List<SpanData.Link> links, List<SpanData.Event> events, ReadableAttributes attributes, int totalAttributeCount, int totalRecordedEvents, SpanData.Status status, String name, long endEpochNanos, boolean hasEnded) {
        return new AutoValue_SpanWrapper(delegate, links, events, attributes, totalAttributeCount, totalRecordedEvents, status, name, endEpochNanos, hasEnded);
    }

    @Override
    public String getTraceId() {
        return this.delegate().getSpanContext().getTraceIdAsHexString();
    }

    @Override
    public String getSpanId() {
        return this.delegate().getSpanContext().getSpanIdAsHexString();
    }

    @Override
    public boolean isSampled() {
        return this.delegate().getSpanContext().isSampled();
    }

    @Override
    public TraceState getTraceState() {
        return this.delegate().getSpanContext().getTraceState();
    }

    @Override
    public String getParentSpanId() {
        return this.delegate().getParentSpanId();
    }

    @Override
    public Resource getResource() {
        return this.delegate().getResource();
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.delegate().getInstrumentationLibraryInfo();
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public Span.Kind getKind() {
        return this.delegate().getKind();
    }

    @Override
    public long getStartEpochNanos() {
        return this.delegate().getStartEpochNanos();
    }

    @Override
    public ReadableAttributes getAttributes() {
        return this.attributes();
    }

    @Override
    public List<SpanData.Event> getEvents() {
        return this.resolvedEvents();
    }

    @Override
    public List<SpanData.Link> getLinks() {
        return this.resolvedLinks();
    }

    @Override
    public SpanData.Status getStatus() {
        return this.status();
    }

    @Override
    public long getEndEpochNanos() {
        return this.endEpochNanos();
    }

    @Override
    public boolean hasRemoteParent() {
        return this.delegate().hasRemoteParent();
    }

    @Override
    public boolean hasEnded() {
        return this.internalHasEnded();
    }

    @Override
    public int getTotalRecordedEvents() {
        return this.totalRecordedEvents();
    }

    @Override
    public int getTotalRecordedLinks() {
        return this.delegate().getTotalRecordedLinks();
    }

    @Override
    public int getTotalAttributeCount() {
        return this.totalAttributeCount();
    }
}

