/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.trace.SpanBuilderSdk;
import io.opentelemetry.sdk.trace.TracerSharedState;

final class TracerSdk
implements Tracer {
    private final TracerSharedState sharedState;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;

    TracerSdk(TracerSharedState sharedState, InstrumentationLibraryInfo instrumentationLibraryInfo) {
        this.sharedState = sharedState;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
    }

    public SpanBuilder spanBuilder(String spanName) {
        if (this.sharedState.isStopped()) {
            return Tracer.getDefault().spanBuilder(spanName);
        }
        return new SpanBuilderSdk(spanName, this.instrumentationLibraryInfo, this.sharedState.getActiveSpanProcessor(), this.sharedState.getActiveTraceConfig(), this.sharedState.getResource(), this.sharedState.getIdsGenerator(), this.sharedState.getClock());
    }

    InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }
}

