/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.internal.MillisClock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.TracerSdk;
import io.opentelemetry.sdk.trace.TracerSdkManagement;
import io.opentelemetry.sdk.trace.TracerSharedState;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class TracerSdkProvider
implements TracerProvider,
TracerSdkManagement {
    private static final Logger logger = Logger.getLogger(TracerSdkProvider.class.getName());
    static final String DEFAULT_TRACER_NAME = "unknown";
    private final TracerSharedState sharedState;
    private final TracerSdkComponentRegistry tracerSdkComponentRegistry;

    public static Builder builder() {
        return new Builder();
    }

    private TracerSdkProvider(Clock clock, IdGenerator idsGenerator, Resource resource) {
        this.sharedState = new TracerSharedState(clock, idsGenerator, resource);
        this.tracerSdkComponentRegistry = new TracerSdkComponentRegistry(this.sharedState);
    }

    public Tracer get(String instrumentationName) {
        return this.get(instrumentationName, null);
    }

    public Tracer get(String instrumentationName, @Nullable String instrumentationVersion) {
        if (instrumentationName == null || instrumentationName.isEmpty()) {
            logger.fine("Tracer requested without instrumentation name.");
            instrumentationName = DEFAULT_TRACER_NAME;
        }
        return (Tracer)this.tracerSdkComponentRegistry.get(instrumentationName, instrumentationVersion);
    }

    @Override
    public TraceConfig getActiveTraceConfig() {
        return this.sharedState.getActiveTraceConfig();
    }

    @Override
    public void updateActiveTraceConfig(TraceConfig traceConfig) {
        this.sharedState.updateActiveTraceConfig(traceConfig);
    }

    @Override
    public void addSpanProcessor(SpanProcessor spanProcessor) {
        this.sharedState.addSpanProcessor(spanProcessor);
    }

    @Override
    public void shutdown() {
        if (this.sharedState.isStopped()) {
            logger.log(Level.WARNING, "Calling shutdown() multiple times.");
            return;
        }
        this.sharedState.stop();
    }

    @Override
    public CompletableResultCode forceFlush() {
        return this.sharedState.getActiveSpanProcessor().forceFlush();
    }

    private static final class TracerSdkComponentRegistry
    extends ComponentRegistry<TracerSdk> {
        private final TracerSharedState sharedState;

        private TracerSdkComponentRegistry(TracerSharedState sharedState) {
            this.sharedState = sharedState;
        }

        public TracerSdk newComponent(InstrumentationLibraryInfo instrumentationLibraryInfo) {
            return new TracerSdk(this.sharedState, instrumentationLibraryInfo);
        }
    }

    public static class Builder {
        private Clock clock = MillisClock.getInstance();
        private IdGenerator idsGenerator = IdGenerator.random();
        private Resource resource = Resource.getDefault();

        public Builder setClock(Clock clock) {
            Objects.requireNonNull(clock, "clock");
            this.clock = clock;
            return this;
        }

        public Builder setIdsGenerator(IdGenerator idsGenerator) {
            Objects.requireNonNull(idsGenerator, "idsGenerator");
            this.idsGenerator = idsGenerator;
            return this;
        }

        public Builder setResource(Resource resource) {
            Objects.requireNonNull(resource, "resource");
            this.resource = resource;
            return this;
        }

        public TracerSdkProvider build() {
            return new TracerSdkProvider(this.clock, this.idsGenerator, this.resource);
        }

        private Builder() {
        }
    }
}

