/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.config;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.common.export.ConfigBuilder;
import io.opentelemetry.sdk.trace.Sampler;
import io.opentelemetry.sdk.trace.Samplers;
import io.opentelemetry.sdk.trace.config.AutoValue_TraceConfig;
import java.util.Map;
import java.util.Properties;
import javax.annotation.concurrent.Immutable;

@AutoValue
@Immutable
public abstract class TraceConfig {
    private static final Sampler DEFAULT_SAMPLER = Samplers.parentBased(Samplers.alwaysOn());
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_EVENTS = 128;
    private static final int DEFAULT_SPAN_MAX_NUM_LINKS = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = 32;
    private static final int DEFAULT_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = 32;
    public static final int UNLIMITED_ATTRIBUTE_LENGTH = -1;
    private static final int DEFAULT_MAX_ATTRIBUTE_LENGTH = -1;
    private static final TraceConfig DEFAULT = TraceConfig.newBuilder().build();

    public static TraceConfig getDefault() {
        return DEFAULT;
    }

    public abstract Sampler getSampler();

    public abstract int getMaxNumberOfAttributes();

    public abstract int getMaxNumberOfEvents();

    public abstract int getMaxNumberOfLinks();

    public abstract int getMaxNumberOfAttributesPerEvent();

    public abstract int getMaxNumberOfAttributesPerLink();

    public abstract int getMaxLengthOfAttributeValues();

    public boolean shouldTruncateStringAttributeValues() {
        return this.getMaxLengthOfAttributeValues() != -1;
    }

    private static Builder newBuilder() {
        return new AutoValue_TraceConfig.Builder().setSampler(DEFAULT_SAMPLER).setMaxNumberOfAttributes(32).setMaxNumberOfEvents(128).setMaxNumberOfLinks(32).setMaxNumberOfAttributesPerEvent(32).setMaxNumberOfAttributesPerLink(32).setMaxLengthOfAttributeValues(-1);
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public static abstract class Builder
    extends ConfigBuilder<Builder> {
        private static final String KEY_SAMPLER_PROBABILITY = "otel.config.sampler.probability";
        private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES = "otel.config.max.attrs";
        private static final String KEY_SPAN_MAX_NUM_EVENTS = "otel.config.max.events";
        private static final String KEY_SPAN_MAX_NUM_LINKS = "otel.config.max.links";
        private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT = "otel.config.max.event.attrs";
        private static final String KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK = "otel.config.max.link.attrs";
        private static final String KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH = "otel.config.max.attr.length";

        Builder() {
        }

        @VisibleForTesting
        protected Builder fromConfigMap(Map<String, String> configMap, ConfigBuilder.NamingConvention namingConvention) {
            Integer intValue;
            Double doubleValue = Builder.getDoubleProperty((String)KEY_SAMPLER_PROBABILITY, (Map)(configMap = namingConvention.normalize(configMap)));
            if (doubleValue != null) {
                this.setSamplerProbability(doubleValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributes(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_EVENTS, (Map)configMap)) != null) {
                this.setMaxNumberOfEvents(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_LINKS, (Map)configMap)) != null) {
                this.setMaxNumberOfLinks(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_EVENT, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributesPerEvent(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_MAX_NUM_ATTRIBUTES_PER_LINK, (Map)configMap)) != null) {
                this.setMaxNumberOfAttributesPerLink(intValue);
            }
            if ((intValue = Builder.getIntProperty((String)KEY_SPAN_ATTRIBUTE_MAX_VALUE_LENGTH, (Map)configMap)) != null) {
                this.setMaxLengthOfAttributeValues(intValue);
            }
            return this;
        }

        public Builder readProperties(Properties properties) {
            return (Builder)((Object)super.readProperties(properties));
        }

        public Builder readEnvironmentVariables() {
            return (Builder)((Object)super.readEnvironmentVariables());
        }

        public Builder readSystemProperties() {
            return (Builder)((Object)super.readSystemProperties());
        }

        public abstract Builder setSampler(Sampler var1);

        public Builder setSamplerProbability(double samplerProbability) {
            Utils.checkArgument((samplerProbability >= 0.0 ? 1 : 0) != 0, (String)"samplerProbability must be greater than or equal to 0.");
            Utils.checkArgument((samplerProbability <= 1.0 ? 1 : 0) != 0, (String)"samplerProbability must be lesser than or equal to 1.");
            if (samplerProbability == 1.0) {
                this.setSampler(Samplers.parentBased(Samplers.alwaysOn()));
            } else if (samplerProbability == 0.0) {
                this.setSampler(Samplers.alwaysOff());
            } else {
                this.setSampler(Samplers.parentBased(Samplers.probability(samplerProbability)));
            }
            return this;
        }

        public abstract Builder setMaxNumberOfAttributes(int var1);

        public abstract Builder setMaxNumberOfEvents(int var1);

        public abstract Builder setMaxNumberOfLinks(int var1);

        public abstract Builder setMaxNumberOfAttributesPerEvent(int var1);

        public abstract Builder setMaxNumberOfAttributesPerLink(int var1);

        public abstract Builder setMaxLengthOfAttributeValues(int var1);

        abstract TraceConfig autoBuild();

        public TraceConfig build() {
            TraceConfig traceConfig = this.autoBuild();
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributes() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributes");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfEvents() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfEvents");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfLinks() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfLinks");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributesPerEvent() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributesPerEvent");
            Preconditions.checkArgument((traceConfig.getMaxNumberOfAttributesPerLink() > 0 ? 1 : 0) != 0, (Object)"maxNumberOfAttributesPerLink");
            Preconditions.checkArgument((traceConfig.getMaxLengthOfAttributeValues() >= -1 ? 1 : 0) != 0, (Object)"maxLengthOfAttributeValues");
            return traceConfig;
        }
    }
}

