/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import com.google.common.collect.EvictingQueue;
import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.AttributesMap;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.SpanWrapper;
import io.opentelemetry.sdk.trace.StringUtils;
import io.opentelemetry.sdk.trace.config.TraceConfig;
import io.opentelemetry.sdk.trace.data.ImmutableEvent;
import io.opentelemetry.sdk.trace.data.ImmutableStatus;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.trace.EndSpanOptions;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.StatusCanonicalCode;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.attributes.SemanticAttributes;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class RecordEventsReadableSpan
implements ReadWriteSpan {
    private static final Logger logger = Logger.getLogger(Tracer.class.getName());
    private final TraceConfig traceConfig;
    private final SpanContext context;
    private final String parentSpanId;
    private final boolean hasRemoteParent;
    private final SpanProcessor spanProcessor;
    private final List<SpanData.Link> links;
    private final int totalRecordedLinks;
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private String name;
    private final Span.Kind kind;
    private final Clock clock;
    private final Resource resource;
    private final InstrumentationLibraryInfo instrumentationLibraryInfo;
    private final long startEpochNanos;
    @Nullable
    @GuardedBy(value="lock")
    private AttributesMap attributes;
    @GuardedBy(value="lock")
    private final EvictingQueue<ImmutableEvent> events;
    @GuardedBy(value="lock")
    private int totalRecordedEvents = 0;
    @Nullable
    @GuardedBy(value="lock")
    private SpanData.Status status = ImmutableStatus.UNSET;
    @GuardedBy(value="lock")
    private long endEpochNanos;
    @GuardedBy(value="lock")
    private boolean hasEnded;

    private RecordEventsReadableSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, String parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, @Nullable AttributesMap attributes, List<SpanData.Link> links, int totalRecordedLinks, long startEpochNanos) {
        this.context = context;
        this.instrumentationLibraryInfo = instrumentationLibraryInfo;
        this.parentSpanId = parentSpanId;
        this.hasRemoteParent = hasRemoteParent;
        this.links = links;
        this.totalRecordedLinks = totalRecordedLinks;
        this.name = name;
        this.kind = kind;
        this.spanProcessor = spanProcessor;
        this.resource = resource;
        this.hasEnded = false;
        this.clock = clock;
        this.startEpochNanos = startEpochNanos;
        this.attributes = attributes;
        this.events = EvictingQueue.create((int)traceConfig.getMaxNumberOfEvents());
        this.traceConfig = traceConfig;
    }

    static RecordEventsReadableSpan startSpan(SpanContext context, String name, InstrumentationLibraryInfo instrumentationLibraryInfo, Span.Kind kind, @Nullable String parentSpanId, boolean hasRemoteParent, TraceConfig traceConfig, SpanProcessor spanProcessor, Clock clock, Resource resource, AttributesMap attributes, List<SpanData.Link> links, int totalRecordedLinks, long startEpochNanos) {
        RecordEventsReadableSpan span = new RecordEventsReadableSpan(context, name, instrumentationLibraryInfo, kind, parentSpanId, hasRemoteParent, traceConfig, spanProcessor, clock, resource, attributes, links, totalRecordedLinks, startEpochNanos == 0L ? clock.now() : startEpochNanos);
        spanProcessor.onStart(span);
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpanData toSpanData() {
        Object object = this.lock;
        synchronized (object) {
            return SpanWrapper.create(this, this.links, this.getImmutableTimedEvents(), this.getImmutableAttributes(), this.attributes == null ? 0 : this.attributes.getTotalAddedValues(), this.totalRecordedEvents, this.getStatusWithDefault(), this.name, this.endEpochNanos, this.hasEnded);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasEnded() {
        Object object = this.lock;
        synchronized (object) {
            return this.hasEnded;
        }
    }

    @Override
    public SpanContext getSpanContext() {
        return this.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getName() {
        Object object = this.lock;
        synchronized (object) {
            return this.name;
        }
    }

    @Override
    public InstrumentationLibraryInfo getInstrumentationLibraryInfo() {
        return this.instrumentationLibraryInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getEndEpochNanos() {
        Object object = this.lock;
        synchronized (object) {
            return this.endEpochNanos;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLatencyNanos() {
        Object object = this.lock;
        synchronized (object) {
            return (this.hasEnded ? this.endEpochNanos : this.clock.now()) - this.startEpochNanos;
        }
    }

    Clock getClock() {
        return this.clock;
    }

    public void setAttribute(String key, String value) {
        this.setAttribute(AttributeKey.stringKey((String)key), value);
    }

    public void setAttribute(String key, long value) {
        this.setAttribute(AttributeKey.longKey((String)key), Long.valueOf(value));
    }

    public void setAttribute(String key, double value) {
        this.setAttribute(AttributeKey.doubleKey((String)key), Double.valueOf(value));
    }

    public void setAttribute(String key, boolean value) {
        this.setAttribute(AttributeKey.booleanKey((String)key), Boolean.valueOf(value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || key.getKey().length() == 0 || value == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setAttribute() on an ended Span.");
                return;
            }
            if (this.attributes == null) {
                this.attributes = new AttributesMap(this.traceConfig.getMaxNumberOfAttributes());
            }
            if (this.traceConfig.shouldTruncateStringAttributeValues()) {
                value = StringUtils.truncateToSize(key, value, this.traceConfig.getMaxLengthOfAttributeValues());
            }
            this.attributes.put(key, value);
        }
    }

    public void addEvent(String name) {
        if (name == null) {
            return;
        }
        this.addTimedEvent(ImmutableEvent.create(this.clock.now(), name, Attributes.empty(), 0));
    }

    public void addEvent(String name, long timestamp) {
        if (name == null) {
            return;
        }
        this.addTimedEvent(ImmutableEvent.create(timestamp, name, Attributes.empty(), 0));
    }

    public void addEvent(String name, Attributes attributes) {
        if (name == null) {
            return;
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(ImmutableEvent.create(this.clock.now(), name, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
    }

    public void addEvent(String name, Attributes attributes, long timestamp) {
        if (name == null) {
            return;
        }
        int totalAttributeCount = attributes.size();
        this.addTimedEvent(ImmutableEvent.create(timestamp, name, RecordEventsReadableSpan.copyAndLimitAttributes(attributes, this.traceConfig.getMaxNumberOfAttributesPerEvent()), totalAttributeCount));
    }

    static Attributes copyAndLimitAttributes(Attributes attributes, int limit) {
        if (attributes.isEmpty() || attributes.size() <= limit) {
            return attributes;
        }
        Attributes.Builder result = Attributes.newBuilder();
        attributes.forEach((AttributeConsumer)new LimitingAttributeConsumer(limit, result));
        return result.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addTimedEvent(ImmutableEvent timedEvent) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling addEvent() on an ended Span.");
                return;
            }
            this.events.add((Object)timedEvent);
            ++this.totalRecordedEvents;
        }
    }

    public void setStatus(StatusCanonicalCode canonicalCode) {
        this.setStatus(canonicalCode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(StatusCanonicalCode canonicalCode, @Nullable String description) {
        if (canonicalCode == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling setStatus() on an ended Span.");
                return;
            }
            this.status = ImmutableStatus.create(canonicalCode, description);
        }
    }

    public void recordException(Throwable exception) {
        this.recordException(exception, null);
    }

    public void recordException(Throwable exception, Attributes additionalAttributes) {
        if (exception == null) {
            return;
        }
        long timestamp = this.clock.now();
        Attributes.Builder attributes = Attributes.newBuilder();
        attributes.setAttribute(SemanticAttributes.EXCEPTION_TYPE, (Object)exception.getClass().getCanonicalName());
        if (exception.getMessage() != null) {
            attributes.setAttribute(SemanticAttributes.EXCEPTION_MESSAGE, (Object)exception.getMessage());
        }
        StringWriter writer = new StringWriter();
        exception.printStackTrace(new PrintWriter(writer));
        attributes.setAttribute(SemanticAttributes.EXCEPTION_STACKTRACE, (Object)writer.toString());
        if (additionalAttributes != null) {
            attributes.addAll(additionalAttributes);
        }
        this.addEvent("exception", attributes.build(), timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateName(String name) {
        if (name == null) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling updateName() on an ended Span.");
                return;
            }
            this.name = name;
        }
    }

    public void end() {
        this.endInternal(this.clock.now());
    }

    public void end(EndSpanOptions endOptions) {
        if (endOptions == null) {
            this.end();
            return;
        }
        this.endInternal(endOptions.getEndTimestamp() == 0L ? this.clock.now() : endOptions.getEndTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endInternal(long endEpochNanos) {
        Object object = this.lock;
        synchronized (object) {
            if (this.hasEnded) {
                logger.log(Level.FINE, "Calling end() on an ended Span.");
                return;
            }
            this.endEpochNanos = endEpochNanos;
            this.hasEnded = true;
        }
        this.spanProcessor.onEnd(this);
    }

    public SpanContext getContext() {
        return this.context;
    }

    public boolean isRecording() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GuardedBy(value="lock")
    private SpanData.Status getStatusWithDefault() {
        Object object = this.lock;
        synchronized (object) {
            return this.status;
        }
    }

    String getParentSpanId() {
        return this.parentSpanId;
    }

    Resource getResource() {
        return this.resource;
    }

    Span.Kind getKind() {
        return this.kind;
    }

    long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    boolean hasRemoteParent() {
        return this.hasRemoteParent;
    }

    int getTotalRecordedLinks() {
        return this.totalRecordedLinks;
    }

    @GuardedBy(value="lock")
    private List<SpanData.Event> getImmutableTimedEvents() {
        if (this.events.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(new ArrayList<ImmutableEvent>((Collection<ImmutableEvent>)this.events));
    }

    @GuardedBy(value="lock")
    private ReadableAttributes getImmutableAttributes() {
        if (this.attributes == null || this.attributes.isEmpty()) {
            return Attributes.empty();
        }
        if (this.hasEnded) {
            return this.attributes;
        }
        return this.attributes.immutableCopy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        long endEpochNanos;
        long totalRecordedEvents;
        String status;
        String attributes;
        String name;
        Object object = this.lock;
        synchronized (object) {
            name = this.name;
            attributes = String.valueOf(this.attributes);
            status = String.valueOf(this.status);
            totalRecordedEvents = this.totalRecordedEvents;
            endEpochNanos = this.endEpochNanos;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("RecordEventsReadableSpan{traceId=");
        sb.append(this.context.getTraceIdAsHexString());
        sb.append(", spanId=");
        sb.append(this.context.getSpanIdAsHexString());
        sb.append(", parentSpanId=");
        sb.append(this.parentSpanId);
        sb.append(", name=");
        sb.append(name);
        sb.append(", kind=");
        sb.append(this.kind);
        sb.append(", attributes=");
        sb.append(attributes);
        sb.append(", status=");
        sb.append(status);
        sb.append(", totalRecordedEvents=");
        sb.append(totalRecordedEvents);
        sb.append(", totalRecordedLinks=");
        sb.append(this.totalRecordedLinks);
        sb.append(", startEpochNanos=");
        sb.append(this.startEpochNanos);
        sb.append(", endEpochNanos=");
        sb.append(endEpochNanos);
        sb.append("}");
        return sb.toString();
    }

    private static class LimitingAttributeConsumer
    implements AttributeConsumer {
        private final int limit;
        private final Attributes.Builder builder;
        private int added;

        public LimitingAttributeConsumer(int limit, Attributes.Builder builder) {
            this.limit = limit;
            this.builder = builder;
        }

        public void consume(AttributeKey key, Object value) {
            if (this.added < this.limit) {
                this.builder.setAttribute(key, value);
                ++this.added;
            }
        }
    }
}

