/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace.data;

import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.trace.Span;
import io.opentelemetry.trace.SpanContext;
import io.opentelemetry.trace.StatusCanonicalCode;
import io.opentelemetry.trace.TraceState;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public interface SpanData {
    public String getTraceId();

    public String getSpanId();

    public boolean isSampled();

    public TraceState getTraceState();

    public String getParentSpanId();

    public Resource getResource();

    public InstrumentationLibraryInfo getInstrumentationLibraryInfo();

    public String getName();

    public Span.Kind getKind();

    public long getStartEpochNanos();

    public ReadableAttributes getAttributes();

    public List<Event> getEvents();

    public List<Link> getLinks();

    public Status getStatus();

    public long getEndEpochNanos();

    public boolean getHasRemoteParent();

    public boolean getHasEnded();

    public int getTotalRecordedEvents();

    public int getTotalRecordedLinks();

    public int getTotalAttributeCount();

    public static interface Status {
        public StatusCanonicalCode getCanonicalCode();

        @Nullable
        public String getDescription();

        default public boolean isUnset() {
            return StatusCanonicalCode.UNSET == this.getCanonicalCode();
        }

        default public boolean isOk() {
            return this.isUnset() || StatusCanonicalCode.OK == this.getCanonicalCode();
        }
    }

    public static interface Event {
        public String getName();

        public Attributes getAttributes();

        public long getEpochNanos();

        public int getTotalAttributeCount();
    }

    public static interface Link {
        public SpanContext getContext();

        public Attributes getAttributes();

        public int getTotalAttributeCount();
    }
}

