// Generated by the protocol buffer compiler.  DO NOT EDIT!
// NO CHECKED-IN PROTOBUF GENCODE
// source: opentelemetry/proto/metrics/v1/metrics.proto
// Protobuf Java Version: 4.28.3

package io.opentelemetry.proto.metrics.v1;

/**
 * <pre>
 * Defines a Metric which has one or more timeseries.  The following is a
 * brief summary of the Metric data model.  For more details, see:
 *
 * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md
 *
 * The data model and relation between entities is shown in the
 * diagram below. Here, "DataPoint" is the term used to refer to any
 * one of the specific data point value types, and "points" is the term used
 * to refer to any one of the lists of points contained in the Metric.
 *
 * - Metric is composed of a metadata and data.
 * - Metadata part contains a name, description, unit.
 * - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
 * - DataPoint contains timestamps, attributes, and one of the possible value type
 * fields.
 *
 * Metric
 * +------------+
 * |name        |
 * |description |
 * |unit        |     +------------------------------------+
 * |data        |---&gt; |Gauge, Sum, Histogram, Summary, ... |
 * +------------+     +------------------------------------+
 *
 * Data [One of Gauge, Sum, Histogram, Summary, ...]
 * +-----------+
 * |...        |  // Metadata about the Data.
 * |points     |--+
 * +-----------+  |
 * |      +---------------------------+
 * |      |DataPoint 1                |
 * v      |+------+------+   +------+ |
 * +-----+   ||label |label |...|label | |
 * |  1  |--&gt;||value1|value2|...|valueN| |
 * +-----+   |+------+------+   +------+ |
 * |  .  |   |+-----+                    |
 * |  .  |   ||value|                    |
 * |  .  |   |+-----+                    |
 * |  .  |   +---------------------------+
 * |  .  |                   .
 * |  .  |                   .
 * |  .  |                   .
 * |  .  |   +---------------------------+
 * |  .  |   |DataPoint M                |
 * +-----+   |+------+------+   +------+ |
 * |  M  |--&gt;||label |label |...|label | |
 * +-----+   ||value1|value2|...|valueN| |
 * |+------+------+   +------+ |
 * |+-----+                    |
 * ||value|                    |
 * |+-----+                    |
 * +---------------------------+
 *
 * Each distinct type of DataPoint represents the output of a specific
 * aggregation function, the result of applying the DataPoint's
 * associated function of to one or more measurements.
 *
 * All DataPoint types have three common fields:
 * - Attributes includes key-value pairs associated with the data point
 * - TimeUnixNano is required, set to the end time of the aggregation
 * - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
 * having an AggregationTemporality field, as discussed below.
 *
 * Both TimeUnixNano and StartTimeUnixNano values are expressed as
 * UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
 *
 * # TimeUnixNano
 *
 * This field is required, having consistent interpretation across
 * DataPoint types.  TimeUnixNano is the moment corresponding to when
 * the data point's aggregate value was captured.
 *
 * Data points with the 0 value for TimeUnixNano SHOULD be rejected
 * by consumers.
 *
 * # StartTimeUnixNano
 *
 * StartTimeUnixNano in general allows detecting when a sequence of
 * observations is unbroken.  This field indicates to consumers the
 * start time for points with cumulative and delta
 * AggregationTemporality, and it should be included whenever possible
 * to support correct rate calculation.  Although it may be omitted
 * when the start time is truly unknown, setting StartTimeUnixNano is
 * strongly encouraged.
 * </pre>
 *
 * Protobuf type {@code opentelemetry.proto.metrics.v1.Metric}
 */
public final class Metric extends
    com.google.protobuf.GeneratedMessage implements
    // @@protoc_insertion_point(message_implements:opentelemetry.proto.metrics.v1.Metric)
    MetricOrBuilder {
private static final long serialVersionUID = 0L;
  static {
    com.google.protobuf.RuntimeVersion.validateProtobufGencodeVersion(
      com.google.protobuf.RuntimeVersion.RuntimeDomain.PUBLIC,
      /* major= */ 4,
      /* minor= */ 28,
      /* patch= */ 3,
      /* suffix= */ "",
      Metric.class.getName());
  }
  // Use Metric.newBuilder() to construct.
  private Metric(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
    super(builder);
  }
  private Metric() {
    name_ = "";
    description_ = "";
    unit_ = "";
    metadata_ = java.util.Collections.emptyList();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_Metric_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_Metric_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            io.opentelemetry.proto.metrics.v1.Metric.class, io.opentelemetry.proto.metrics.v1.Metric.Builder.class);
  }

  private int dataCase_ = 0;
  @SuppressWarnings("serial")
  private java.lang.Object data_;
  public enum DataCase
      implements com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    GAUGE(5),
    SUM(7),
    HISTOGRAM(9),
    EXPONENTIAL_HISTOGRAM(10),
    SUMMARY(11),
    DATA_NOT_SET(0);
    private final int value;
    private DataCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DataCase valueOf(int value) {
      return forNumber(value);
    }

    public static DataCase forNumber(int value) {
      switch (value) {
        case 5: return GAUGE;
        case 7: return SUM;
        case 9: return HISTOGRAM;
        case 10: return EXPONENTIAL_HISTOGRAM;
        case 11: return SUMMARY;
        case 0: return DATA_NOT_SET;
        default: return null;
      }
    }
    public int getNumber() {
      return this.value;
    }
  };

  public DataCase
  getDataCase() {
    return DataCase.forNumber(
        dataCase_);
  }

  public static final int NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";
  /**
   * <pre>
   * name of the metric.
   * </pre>
   *
   * <code>string name = 1;</code>
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * name of the metric.
   * </pre>
   *
   * <code>string name = 1;</code>
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 2;
  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   * <pre>
   * description of the metric, which can be used in documentation.
   * </pre>
   *
   * <code>string description = 2;</code>
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * description of the metric, which can be used in documentation.
   * </pre>
   *
   * <code>string description = 2;</code>
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int UNIT_FIELD_NUMBER = 3;
  @SuppressWarnings("serial")
  private volatile java.lang.Object unit_ = "";
  /**
   * <pre>
   * unit in which the metric value is reported. Follows the format
   * described by http://unitsofmeasure.org/ucum.html.
   * </pre>
   *
   * <code>string unit = 3;</code>
   * @return The unit.
   */
  @java.lang.Override
  public java.lang.String getUnit() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      unit_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * unit in which the metric value is reported. Follows the format
   * described by http://unitsofmeasure.org/ucum.html.
   * </pre>
   *
   * <code>string unit = 3;</code>
   * @return The bytes for unit.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getUnitBytes() {
    java.lang.Object ref = unit_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      unit_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int GAUGE_FIELD_NUMBER = 5;
  /**
   * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
   * @return Whether the gauge field is set.
   */
  @java.lang.Override
  public boolean hasGauge() {
    return dataCase_ == 5;
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
   * @return The gauge.
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Gauge getGauge() {
    if (dataCase_ == 5) {
       return (io.opentelemetry.proto.metrics.v1.Gauge) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.GaugeOrBuilder getGaugeOrBuilder() {
    if (dataCase_ == 5) {
       return (io.opentelemetry.proto.metrics.v1.Gauge) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
  }

  public static final int SUM_FIELD_NUMBER = 7;
  /**
   * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
   * @return Whether the sum field is set.
   */
  @java.lang.Override
  public boolean hasSum() {
    return dataCase_ == 7;
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
   * @return The sum.
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Sum getSum() {
    if (dataCase_ == 7) {
       return (io.opentelemetry.proto.metrics.v1.Sum) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.SumOrBuilder getSumOrBuilder() {
    if (dataCase_ == 7) {
       return (io.opentelemetry.proto.metrics.v1.Sum) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
  }

  public static final int HISTOGRAM_FIELD_NUMBER = 9;
  /**
   * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
   * @return Whether the histogram field is set.
   */
  @java.lang.Override
  public boolean hasHistogram() {
    return dataCase_ == 9;
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
   * @return The histogram.
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Histogram getHistogram() {
    if (dataCase_ == 9) {
       return (io.opentelemetry.proto.metrics.v1.Histogram) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.HistogramOrBuilder getHistogramOrBuilder() {
    if (dataCase_ == 9) {
       return (io.opentelemetry.proto.metrics.v1.Histogram) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
  }

  public static final int EXPONENTIAL_HISTOGRAM_FIELD_NUMBER = 10;
  /**
   * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
   * @return Whether the exponentialHistogram field is set.
   */
  @java.lang.Override
  public boolean hasExponentialHistogram() {
    return dataCase_ == 10;
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
   * @return The exponentialHistogram.
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.ExponentialHistogram getExponentialHistogram() {
    if (dataCase_ == 10) {
       return (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_;
    }
    return io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.ExponentialHistogramOrBuilder getExponentialHistogramOrBuilder() {
    if (dataCase_ == 10) {
       return (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_;
    }
    return io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
  }

  public static final int SUMMARY_FIELD_NUMBER = 11;
  /**
   * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
   * @return Whether the summary field is set.
   */
  @java.lang.Override
  public boolean hasSummary() {
    return dataCase_ == 11;
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
   * @return The summary.
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Summary getSummary() {
    if (dataCase_ == 11) {
       return (io.opentelemetry.proto.metrics.v1.Summary) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
  }
  /**
   * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.SummaryOrBuilder getSummaryOrBuilder() {
    if (dataCase_ == 11) {
       return (io.opentelemetry.proto.metrics.v1.Summary) data_;
    }
    return io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
  }

  public static final int METADATA_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private java.util.List<io.opentelemetry.proto.common.v1.KeyValue> metadata_;
  /**
   * <pre>
   * Additional metadata attributes that describe the metric. [Optional].
   * Attributes are non-identifying.
   * Consumers SHOULD NOT need to be aware of these attributes.
   * These attributes MAY be used to encode information allowing
   * for lossless roundtrip translation to / from another data model.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
   */
  @java.lang.Override
  public java.util.List<io.opentelemetry.proto.common.v1.KeyValue> getMetadataList() {
    return metadata_;
  }
  /**
   * <pre>
   * Additional metadata attributes that describe the metric. [Optional].
   * Attributes are non-identifying.
   * Consumers SHOULD NOT need to be aware of these attributes.
   * These attributes MAY be used to encode information allowing
   * for lossless roundtrip translation to / from another data model.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
   */
  @java.lang.Override
  public java.util.List<? extends io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
      getMetadataOrBuilderList() {
    return metadata_;
  }
  /**
   * <pre>
   * Additional metadata attributes that describe the metric. [Optional].
   * Attributes are non-identifying.
   * Consumers SHOULD NOT need to be aware of these attributes.
   * These attributes MAY be used to encode information allowing
   * for lossless roundtrip translation to / from another data model.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
   */
  @java.lang.Override
  public int getMetadataCount() {
    return metadata_.size();
  }
  /**
   * <pre>
   * Additional metadata attributes that describe the metric. [Optional].
   * Attributes are non-identifying.
   * Consumers SHOULD NOT need to be aware of these attributes.
   * These attributes MAY be used to encode information allowing
   * for lossless roundtrip translation to / from another data model.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.common.v1.KeyValue getMetadata(int index) {
    return metadata_.get(index);
  }
  /**
   * <pre>
   * Additional metadata attributes that describe the metric. [Optional].
   * Attributes are non-identifying.
   * Consumers SHOULD NOT need to be aware of these attributes.
   * These attributes MAY be used to encode information allowing
   * for lossless roundtrip translation to / from another data model.
   * Attribute keys MUST be unique (it is not allowed to have more than one
   * attribute with the same key).
   * </pre>
   *
   * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
   */
  @java.lang.Override
  public io.opentelemetry.proto.common.v1.KeyValueOrBuilder getMetadataOrBuilder(
      int index) {
    return metadata_.get(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 2, description_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(unit_)) {
      com.google.protobuf.GeneratedMessage.writeString(output, 3, unit_);
    }
    if (dataCase_ == 5) {
      output.writeMessage(5, (io.opentelemetry.proto.metrics.v1.Gauge) data_);
    }
    if (dataCase_ == 7) {
      output.writeMessage(7, (io.opentelemetry.proto.metrics.v1.Sum) data_);
    }
    if (dataCase_ == 9) {
      output.writeMessage(9, (io.opentelemetry.proto.metrics.v1.Histogram) data_);
    }
    if (dataCase_ == 10) {
      output.writeMessage(10, (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_);
    }
    if (dataCase_ == 11) {
      output.writeMessage(11, (io.opentelemetry.proto.metrics.v1.Summary) data_);
    }
    for (int i = 0; i < metadata_.size(); i++) {
      output.writeMessage(12, metadata_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(2, description_);
    }
    if (!com.google.protobuf.GeneratedMessage.isStringEmpty(unit_)) {
      size += com.google.protobuf.GeneratedMessage.computeStringSize(3, unit_);
    }
    if (dataCase_ == 5) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, (io.opentelemetry.proto.metrics.v1.Gauge) data_);
    }
    if (dataCase_ == 7) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(7, (io.opentelemetry.proto.metrics.v1.Sum) data_);
    }
    if (dataCase_ == 9) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(9, (io.opentelemetry.proto.metrics.v1.Histogram) data_);
    }
    if (dataCase_ == 10) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(10, (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_);
    }
    if (dataCase_ == 11) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(11, (io.opentelemetry.proto.metrics.v1.Summary) data_);
    }
    for (int i = 0; i < metadata_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(12, metadata_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof io.opentelemetry.proto.metrics.v1.Metric)) {
      return super.equals(obj);
    }
    io.opentelemetry.proto.metrics.v1.Metric other = (io.opentelemetry.proto.metrics.v1.Metric) obj;

    if (!getName()
        .equals(other.getName())) return false;
    if (!getDescription()
        .equals(other.getDescription())) return false;
    if (!getUnit()
        .equals(other.getUnit())) return false;
    if (!getMetadataList()
        .equals(other.getMetadataList())) return false;
    if (!getDataCase().equals(other.getDataCase())) return false;
    switch (dataCase_) {
      case 5:
        if (!getGauge()
            .equals(other.getGauge())) return false;
        break;
      case 7:
        if (!getSum()
            .equals(other.getSum())) return false;
        break;
      case 9:
        if (!getHistogram()
            .equals(other.getHistogram())) return false;
        break;
      case 10:
        if (!getExponentialHistogram()
            .equals(other.getExponentialHistogram())) return false;
        break;
      case 11:
        if (!getSummary()
            .equals(other.getSummary())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + UNIT_FIELD_NUMBER;
    hash = (53 * hash) + getUnit().hashCode();
    if (getMetadataCount() > 0) {
      hash = (37 * hash) + METADATA_FIELD_NUMBER;
      hash = (53 * hash) + getMetadataList().hashCode();
    }
    switch (dataCase_) {
      case 5:
        hash = (37 * hash) + GAUGE_FIELD_NUMBER;
        hash = (53 * hash) + getGauge().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SUM_FIELD_NUMBER;
        hash = (53 * hash) + getSum().hashCode();
        break;
      case 9:
        hash = (37 * hash) + HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getHistogram().hashCode();
        break;
      case 10:
        hash = (37 * hash) + EXPONENTIAL_HISTOGRAM_FIELD_NUMBER;
        hash = (53 * hash) + getExponentialHistogram().hashCode();
        break;
      case 11:
        hash = (37 * hash) + SUMMARY_FIELD_NUMBER;
        hash = (53 * hash) + getSummary().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static io.opentelemetry.proto.metrics.v1.Metric parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static io.opentelemetry.proto.metrics.v1.Metric parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input);
  }
  public static io.opentelemetry.proto.metrics.v1.Metric parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessage
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(io.opentelemetry.proto.metrics.v1.Metric prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessage.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * Defines a Metric which has one or more timeseries.  The following is a
   * brief summary of the Metric data model.  For more details, see:
   *
   * https://github.com/open-telemetry/opentelemetry-specification/blob/main/specification/metrics/data-model.md
   *
   * The data model and relation between entities is shown in the
   * diagram below. Here, "DataPoint" is the term used to refer to any
   * one of the specific data point value types, and "points" is the term used
   * to refer to any one of the lists of points contained in the Metric.
   *
   * - Metric is composed of a metadata and data.
   * - Metadata part contains a name, description, unit.
   * - Data is one of the possible types (Sum, Gauge, Histogram, Summary).
   * - DataPoint contains timestamps, attributes, and one of the possible value type
   * fields.
   *
   * Metric
   * +------------+
   * |name        |
   * |description |
   * |unit        |     +------------------------------------+
   * |data        |---&gt; |Gauge, Sum, Histogram, Summary, ... |
   * +------------+     +------------------------------------+
   *
   * Data [One of Gauge, Sum, Histogram, Summary, ...]
   * +-----------+
   * |...        |  // Metadata about the Data.
   * |points     |--+
   * +-----------+  |
   * |      +---------------------------+
   * |      |DataPoint 1                |
   * v      |+------+------+   +------+ |
   * +-----+   ||label |label |...|label | |
   * |  1  |--&gt;||value1|value2|...|valueN| |
   * +-----+   |+------+------+   +------+ |
   * |  .  |   |+-----+                    |
   * |  .  |   ||value|                    |
   * |  .  |   |+-----+                    |
   * |  .  |   +---------------------------+
   * |  .  |                   .
   * |  .  |                   .
   * |  .  |                   .
   * |  .  |   +---------------------------+
   * |  .  |   |DataPoint M                |
   * +-----+   |+------+------+   +------+ |
   * |  M  |--&gt;||label |label |...|label | |
   * +-----+   ||value1|value2|...|valueN| |
   * |+------+------+   +------+ |
   * |+-----+                    |
   * ||value|                    |
   * |+-----+                    |
   * +---------------------------+
   *
   * Each distinct type of DataPoint represents the output of a specific
   * aggregation function, the result of applying the DataPoint's
   * associated function of to one or more measurements.
   *
   * All DataPoint types have three common fields:
   * - Attributes includes key-value pairs associated with the data point
   * - TimeUnixNano is required, set to the end time of the aggregation
   * - StartTimeUnixNano is optional, but strongly encouraged for DataPoints
   * having an AggregationTemporality field, as discussed below.
   *
   * Both TimeUnixNano and StartTimeUnixNano values are expressed as
   * UNIX Epoch time in nanoseconds since 00:00:00 UTC on 1 January 1970.
   *
   * # TimeUnixNano
   *
   * This field is required, having consistent interpretation across
   * DataPoint types.  TimeUnixNano is the moment corresponding to when
   * the data point's aggregate value was captured.
   *
   * Data points with the 0 value for TimeUnixNano SHOULD be rejected
   * by consumers.
   *
   * # StartTimeUnixNano
   *
   * StartTimeUnixNano in general allows detecting when a sequence of
   * observations is unbroken.  This field indicates to consumers the
   * start time for points with cumulative and delta
   * AggregationTemporality, and it should be included whenever possible
   * to support correct rate calculation.  Although it may be omitted
   * when the start time is truly unknown, setting StartTimeUnixNano is
   * strongly encouraged.
   * </pre>
   *
   * Protobuf type {@code opentelemetry.proto.metrics.v1.Metric}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessage.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:opentelemetry.proto.metrics.v1.Metric)
      io.opentelemetry.proto.metrics.v1.MetricOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_Metric_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_Metric_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              io.opentelemetry.proto.metrics.v1.Metric.class, io.opentelemetry.proto.metrics.v1.Metric.Builder.class);
    }

    // Construct using io.opentelemetry.proto.metrics.v1.Metric.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      description_ = "";
      unit_ = "";
      if (gaugeBuilder_ != null) {
        gaugeBuilder_.clear();
      }
      if (sumBuilder_ != null) {
        sumBuilder_.clear();
      }
      if (histogramBuilder_ != null) {
        histogramBuilder_.clear();
      }
      if (exponentialHistogramBuilder_ != null) {
        exponentialHistogramBuilder_.clear();
      }
      if (summaryBuilder_ != null) {
        summaryBuilder_.clear();
      }
      if (metadataBuilder_ == null) {
        metadata_ = java.util.Collections.emptyList();
      } else {
        metadata_ = null;
        metadataBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000100);
      dataCase_ = 0;
      data_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return io.opentelemetry.proto.metrics.v1.MetricsProto.internal_static_opentelemetry_proto_metrics_v1_Metric_descriptor;
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Metric getDefaultInstanceForType() {
      return io.opentelemetry.proto.metrics.v1.Metric.getDefaultInstance();
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Metric build() {
      io.opentelemetry.proto.metrics.v1.Metric result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Metric buildPartial() {
      io.opentelemetry.proto.metrics.v1.Metric result = new io.opentelemetry.proto.metrics.v1.Metric(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) { buildPartial0(result); }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(io.opentelemetry.proto.metrics.v1.Metric result) {
      if (metadataBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)) {
          metadata_ = java.util.Collections.unmodifiableList(metadata_);
          bitField0_ = (bitField0_ & ~0x00000100);
        }
        result.metadata_ = metadata_;
      } else {
        result.metadata_ = metadataBuilder_.build();
      }
    }

    private void buildPartial0(io.opentelemetry.proto.metrics.v1.Metric result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.unit_ = unit_;
      }
    }

    private void buildPartialOneofs(io.opentelemetry.proto.metrics.v1.Metric result) {
      result.dataCase_ = dataCase_;
      result.data_ = this.data_;
      if (dataCase_ == 5 &&
          gaugeBuilder_ != null) {
        result.data_ = gaugeBuilder_.build();
      }
      if (dataCase_ == 7 &&
          sumBuilder_ != null) {
        result.data_ = sumBuilder_.build();
      }
      if (dataCase_ == 9 &&
          histogramBuilder_ != null) {
        result.data_ = histogramBuilder_.build();
      }
      if (dataCase_ == 10 &&
          exponentialHistogramBuilder_ != null) {
        result.data_ = exponentialHistogramBuilder_.build();
      }
      if (dataCase_ == 11 &&
          summaryBuilder_ != null) {
        result.data_ = summaryBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof io.opentelemetry.proto.metrics.v1.Metric) {
        return mergeFrom((io.opentelemetry.proto.metrics.v1.Metric)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(io.opentelemetry.proto.metrics.v1.Metric other) {
      if (other == io.opentelemetry.proto.metrics.v1.Metric.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getUnit().isEmpty()) {
        unit_ = other.unit_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (metadataBuilder_ == null) {
        if (!other.metadata_.isEmpty()) {
          if (metadata_.isEmpty()) {
            metadata_ = other.metadata_;
            bitField0_ = (bitField0_ & ~0x00000100);
          } else {
            ensureMetadataIsMutable();
            metadata_.addAll(other.metadata_);
          }
          onChanged();
        }
      } else {
        if (!other.metadata_.isEmpty()) {
          if (metadataBuilder_.isEmpty()) {
            metadataBuilder_.dispose();
            metadataBuilder_ = null;
            metadata_ = other.metadata_;
            bitField0_ = (bitField0_ & ~0x00000100);
            metadataBuilder_ = 
              com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                 getMetadataFieldBuilder() : null;
          } else {
            metadataBuilder_.addAllMessages(other.metadata_);
          }
        }
      }
      switch (other.getDataCase()) {
        case GAUGE: {
          mergeGauge(other.getGauge());
          break;
        }
        case SUM: {
          mergeSum(other.getSum());
          break;
        }
        case HISTOGRAM: {
          mergeHistogram(other.getHistogram());
          break;
        }
        case EXPONENTIAL_HISTOGRAM: {
          mergeExponentialHistogram(other.getExponentialHistogram());
          break;
        }
        case SUMMARY: {
          mergeSummary(other.getSummary());
          break;
        }
        case DATA_NOT_SET: {
          break;
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              name_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 18: {
              description_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 18
            case 26: {
              unit_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 26
            case 42: {
              input.readMessage(
                  getGaugeFieldBuilder().getBuilder(),
                  extensionRegistry);
              dataCase_ = 5;
              break;
            } // case 42
            case 58: {
              input.readMessage(
                  getSumFieldBuilder().getBuilder(),
                  extensionRegistry);
              dataCase_ = 7;
              break;
            } // case 58
            case 74: {
              input.readMessage(
                  getHistogramFieldBuilder().getBuilder(),
                  extensionRegistry);
              dataCase_ = 9;
              break;
            } // case 74
            case 82: {
              input.readMessage(
                  getExponentialHistogramFieldBuilder().getBuilder(),
                  extensionRegistry);
              dataCase_ = 10;
              break;
            } // case 82
            case 90: {
              input.readMessage(
                  getSummaryFieldBuilder().getBuilder(),
                  extensionRegistry);
              dataCase_ = 11;
              break;
            } // case 90
            case 98: {
              io.opentelemetry.proto.common.v1.KeyValue m =
                  input.readMessage(
                      io.opentelemetry.proto.common.v1.KeyValue.parser(),
                      extensionRegistry);
              if (metadataBuilder_ == null) {
                ensureMetadataIsMutable();
                metadata_.add(m);
              } else {
                metadataBuilder_.addMessage(m);
              }
              break;
            } // case 98
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int dataCase_ = 0;
    private java.lang.Object data_;
    public DataCase
        getDataCase() {
      return DataCase.forNumber(
          dataCase_);
    }

    public Builder clearData() {
      dataCase_ = 0;
      data_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";
    /**
     * <pre>
     * name of the metric.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * name of the metric.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * name of the metric.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * name of the metric.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * name of the metric.
     * </pre>
     *
     * <code>string name = 1;</code>
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     * <pre>
     * description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString
        getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 2;</code>
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 2;</code>
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * description of the metric, which can be used in documentation.
     * </pre>
     *
     * <code>string description = 2;</code>
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object unit_ = "";
    /**
     * <pre>
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     * </pre>
     *
     * <code>string unit = 3;</code>
     * @return The unit.
     */
    public java.lang.String getUnit() {
      java.lang.Object ref = unit_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        unit_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     * </pre>
     *
     * <code>string unit = 3;</code>
     * @return The bytes for unit.
     */
    public com.google.protobuf.ByteString
        getUnitBytes() {
      java.lang.Object ref = unit_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        unit_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     * </pre>
     *
     * <code>string unit = 3;</code>
     * @param value The unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnit(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      unit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     * </pre>
     *
     * <code>string unit = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearUnit() {
      unit_ = getDefaultInstance().getUnit();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * unit in which the metric value is reported. Follows the format
     * described by http://unitsofmeasure.org/ucum.html.
     * </pre>
     *
     * <code>string unit = 3;</code>
     * @param value The bytes for unit to set.
     * @return This builder for chaining.
     */
    public Builder setUnitBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      unit_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Gauge, io.opentelemetry.proto.metrics.v1.Gauge.Builder, io.opentelemetry.proto.metrics.v1.GaugeOrBuilder> gaugeBuilder_;
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     * @return Whether the gauge field is set.
     */
    @java.lang.Override
    public boolean hasGauge() {
      return dataCase_ == 5;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     * @return The gauge.
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Gauge getGauge() {
      if (gaugeBuilder_ == null) {
        if (dataCase_ == 5) {
          return (io.opentelemetry.proto.metrics.v1.Gauge) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
      } else {
        if (dataCase_ == 5) {
          return gaugeBuilder_.getMessage();
        }
        return io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    public Builder setGauge(io.opentelemetry.proto.metrics.v1.Gauge value) {
      if (gaugeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        gaugeBuilder_.setMessage(value);
      }
      dataCase_ = 5;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    public Builder setGauge(
        io.opentelemetry.proto.metrics.v1.Gauge.Builder builderForValue) {
      if (gaugeBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        gaugeBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 5;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    public Builder mergeGauge(io.opentelemetry.proto.metrics.v1.Gauge value) {
      if (gaugeBuilder_ == null) {
        if (dataCase_ == 5 &&
            data_ != io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance()) {
          data_ = io.opentelemetry.proto.metrics.v1.Gauge.newBuilder((io.opentelemetry.proto.metrics.v1.Gauge) data_)
              .mergeFrom(value).buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 5) {
          gaugeBuilder_.mergeFrom(value);
        } else {
          gaugeBuilder_.setMessage(value);
        }
      }
      dataCase_ = 5;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    public Builder clearGauge() {
      if (gaugeBuilder_ == null) {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 5) {
          dataCase_ = 0;
          data_ = null;
        }
        gaugeBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Gauge.Builder getGaugeBuilder() {
      return getGaugeFieldBuilder().getBuilder();
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.GaugeOrBuilder getGaugeOrBuilder() {
      if ((dataCase_ == 5) && (gaugeBuilder_ != null)) {
        return gaugeBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 5) {
          return (io.opentelemetry.proto.metrics.v1.Gauge) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Gauge gauge = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Gauge, io.opentelemetry.proto.metrics.v1.Gauge.Builder, io.opentelemetry.proto.metrics.v1.GaugeOrBuilder> 
        getGaugeFieldBuilder() {
      if (gaugeBuilder_ == null) {
        if (!(dataCase_ == 5)) {
          data_ = io.opentelemetry.proto.metrics.v1.Gauge.getDefaultInstance();
        }
        gaugeBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            io.opentelemetry.proto.metrics.v1.Gauge, io.opentelemetry.proto.metrics.v1.Gauge.Builder, io.opentelemetry.proto.metrics.v1.GaugeOrBuilder>(
                (io.opentelemetry.proto.metrics.v1.Gauge) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 5;
      onChanged();
      return gaugeBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Sum, io.opentelemetry.proto.metrics.v1.Sum.Builder, io.opentelemetry.proto.metrics.v1.SumOrBuilder> sumBuilder_;
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     * @return Whether the sum field is set.
     */
    @java.lang.Override
    public boolean hasSum() {
      return dataCase_ == 7;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     * @return The sum.
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Sum getSum() {
      if (sumBuilder_ == null) {
        if (dataCase_ == 7) {
          return (io.opentelemetry.proto.metrics.v1.Sum) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
      } else {
        if (dataCase_ == 7) {
          return sumBuilder_.getMessage();
        }
        return io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    public Builder setSum(io.opentelemetry.proto.metrics.v1.Sum value) {
      if (sumBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        sumBuilder_.setMessage(value);
      }
      dataCase_ = 7;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    public Builder setSum(
        io.opentelemetry.proto.metrics.v1.Sum.Builder builderForValue) {
      if (sumBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        sumBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 7;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    public Builder mergeSum(io.opentelemetry.proto.metrics.v1.Sum value) {
      if (sumBuilder_ == null) {
        if (dataCase_ == 7 &&
            data_ != io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance()) {
          data_ = io.opentelemetry.proto.metrics.v1.Sum.newBuilder((io.opentelemetry.proto.metrics.v1.Sum) data_)
              .mergeFrom(value).buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 7) {
          sumBuilder_.mergeFrom(value);
        } else {
          sumBuilder_.setMessage(value);
        }
      }
      dataCase_ = 7;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    public Builder clearSum() {
      if (sumBuilder_ == null) {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 7) {
          dataCase_ = 0;
          data_ = null;
        }
        sumBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Sum.Builder getSumBuilder() {
      return getSumFieldBuilder().getBuilder();
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.SumOrBuilder getSumOrBuilder() {
      if ((dataCase_ == 7) && (sumBuilder_ != null)) {
        return sumBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 7) {
          return (io.opentelemetry.proto.metrics.v1.Sum) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Sum sum = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Sum, io.opentelemetry.proto.metrics.v1.Sum.Builder, io.opentelemetry.proto.metrics.v1.SumOrBuilder> 
        getSumFieldBuilder() {
      if (sumBuilder_ == null) {
        if (!(dataCase_ == 7)) {
          data_ = io.opentelemetry.proto.metrics.v1.Sum.getDefaultInstance();
        }
        sumBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            io.opentelemetry.proto.metrics.v1.Sum, io.opentelemetry.proto.metrics.v1.Sum.Builder, io.opentelemetry.proto.metrics.v1.SumOrBuilder>(
                (io.opentelemetry.proto.metrics.v1.Sum) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 7;
      onChanged();
      return sumBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Histogram, io.opentelemetry.proto.metrics.v1.Histogram.Builder, io.opentelemetry.proto.metrics.v1.HistogramOrBuilder> histogramBuilder_;
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     * @return Whether the histogram field is set.
     */
    @java.lang.Override
    public boolean hasHistogram() {
      return dataCase_ == 9;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     * @return The histogram.
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Histogram getHistogram() {
      if (histogramBuilder_ == null) {
        if (dataCase_ == 9) {
          return (io.opentelemetry.proto.metrics.v1.Histogram) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
      } else {
        if (dataCase_ == 9) {
          return histogramBuilder_.getMessage();
        }
        return io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    public Builder setHistogram(io.opentelemetry.proto.metrics.v1.Histogram value) {
      if (histogramBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        histogramBuilder_.setMessage(value);
      }
      dataCase_ = 9;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    public Builder setHistogram(
        io.opentelemetry.proto.metrics.v1.Histogram.Builder builderForValue) {
      if (histogramBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        histogramBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 9;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    public Builder mergeHistogram(io.opentelemetry.proto.metrics.v1.Histogram value) {
      if (histogramBuilder_ == null) {
        if (dataCase_ == 9 &&
            data_ != io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance()) {
          data_ = io.opentelemetry.proto.metrics.v1.Histogram.newBuilder((io.opentelemetry.proto.metrics.v1.Histogram) data_)
              .mergeFrom(value).buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 9) {
          histogramBuilder_.mergeFrom(value);
        } else {
          histogramBuilder_.setMessage(value);
        }
      }
      dataCase_ = 9;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    public Builder clearHistogram() {
      if (histogramBuilder_ == null) {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 9) {
          dataCase_ = 0;
          data_ = null;
        }
        histogramBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Histogram.Builder getHistogramBuilder() {
      return getHistogramFieldBuilder().getBuilder();
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.HistogramOrBuilder getHistogramOrBuilder() {
      if ((dataCase_ == 9) && (histogramBuilder_ != null)) {
        return histogramBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 9) {
          return (io.opentelemetry.proto.metrics.v1.Histogram) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Histogram histogram = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Histogram, io.opentelemetry.proto.metrics.v1.Histogram.Builder, io.opentelemetry.proto.metrics.v1.HistogramOrBuilder> 
        getHistogramFieldBuilder() {
      if (histogramBuilder_ == null) {
        if (!(dataCase_ == 9)) {
          data_ = io.opentelemetry.proto.metrics.v1.Histogram.getDefaultInstance();
        }
        histogramBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            io.opentelemetry.proto.metrics.v1.Histogram, io.opentelemetry.proto.metrics.v1.Histogram.Builder, io.opentelemetry.proto.metrics.v1.HistogramOrBuilder>(
                (io.opentelemetry.proto.metrics.v1.Histogram) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 9;
      onChanged();
      return histogramBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.ExponentialHistogram, io.opentelemetry.proto.metrics.v1.ExponentialHistogram.Builder, io.opentelemetry.proto.metrics.v1.ExponentialHistogramOrBuilder> exponentialHistogramBuilder_;
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     * @return Whether the exponentialHistogram field is set.
     */
    @java.lang.Override
    public boolean hasExponentialHistogram() {
      return dataCase_ == 10;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     * @return The exponentialHistogram.
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.ExponentialHistogram getExponentialHistogram() {
      if (exponentialHistogramBuilder_ == null) {
        if (dataCase_ == 10) {
          return (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_;
        }
        return io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
      } else {
        if (dataCase_ == 10) {
          return exponentialHistogramBuilder_.getMessage();
        }
        return io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    public Builder setExponentialHistogram(io.opentelemetry.proto.metrics.v1.ExponentialHistogram value) {
      if (exponentialHistogramBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        exponentialHistogramBuilder_.setMessage(value);
      }
      dataCase_ = 10;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    public Builder setExponentialHistogram(
        io.opentelemetry.proto.metrics.v1.ExponentialHistogram.Builder builderForValue) {
      if (exponentialHistogramBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        exponentialHistogramBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 10;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    public Builder mergeExponentialHistogram(io.opentelemetry.proto.metrics.v1.ExponentialHistogram value) {
      if (exponentialHistogramBuilder_ == null) {
        if (dataCase_ == 10 &&
            data_ != io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance()) {
          data_ = io.opentelemetry.proto.metrics.v1.ExponentialHistogram.newBuilder((io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_)
              .mergeFrom(value).buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 10) {
          exponentialHistogramBuilder_.mergeFrom(value);
        } else {
          exponentialHistogramBuilder_.setMessage(value);
        }
      }
      dataCase_ = 10;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    public Builder clearExponentialHistogram() {
      if (exponentialHistogramBuilder_ == null) {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 10) {
          dataCase_ = 0;
          data_ = null;
        }
        exponentialHistogramBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    public io.opentelemetry.proto.metrics.v1.ExponentialHistogram.Builder getExponentialHistogramBuilder() {
      return getExponentialHistogramFieldBuilder().getBuilder();
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.ExponentialHistogramOrBuilder getExponentialHistogramOrBuilder() {
      if ((dataCase_ == 10) && (exponentialHistogramBuilder_ != null)) {
        return exponentialHistogramBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 10) {
          return (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_;
        }
        return io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.ExponentialHistogram exponential_histogram = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.ExponentialHistogram, io.opentelemetry.proto.metrics.v1.ExponentialHistogram.Builder, io.opentelemetry.proto.metrics.v1.ExponentialHistogramOrBuilder> 
        getExponentialHistogramFieldBuilder() {
      if (exponentialHistogramBuilder_ == null) {
        if (!(dataCase_ == 10)) {
          data_ = io.opentelemetry.proto.metrics.v1.ExponentialHistogram.getDefaultInstance();
        }
        exponentialHistogramBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            io.opentelemetry.proto.metrics.v1.ExponentialHistogram, io.opentelemetry.proto.metrics.v1.ExponentialHistogram.Builder, io.opentelemetry.proto.metrics.v1.ExponentialHistogramOrBuilder>(
                (io.opentelemetry.proto.metrics.v1.ExponentialHistogram) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 10;
      onChanged();
      return exponentialHistogramBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Summary, io.opentelemetry.proto.metrics.v1.Summary.Builder, io.opentelemetry.proto.metrics.v1.SummaryOrBuilder> summaryBuilder_;
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     * @return Whether the summary field is set.
     */
    @java.lang.Override
    public boolean hasSummary() {
      return dataCase_ == 11;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     * @return The summary.
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.Summary getSummary() {
      if (summaryBuilder_ == null) {
        if (dataCase_ == 11) {
          return (io.opentelemetry.proto.metrics.v1.Summary) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
      } else {
        if (dataCase_ == 11) {
          return summaryBuilder_.getMessage();
        }
        return io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    public Builder setSummary(io.opentelemetry.proto.metrics.v1.Summary value) {
      if (summaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        data_ = value;
        onChanged();
      } else {
        summaryBuilder_.setMessage(value);
      }
      dataCase_ = 11;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    public Builder setSummary(
        io.opentelemetry.proto.metrics.v1.Summary.Builder builderForValue) {
      if (summaryBuilder_ == null) {
        data_ = builderForValue.build();
        onChanged();
      } else {
        summaryBuilder_.setMessage(builderForValue.build());
      }
      dataCase_ = 11;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    public Builder mergeSummary(io.opentelemetry.proto.metrics.v1.Summary value) {
      if (summaryBuilder_ == null) {
        if (dataCase_ == 11 &&
            data_ != io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance()) {
          data_ = io.opentelemetry.proto.metrics.v1.Summary.newBuilder((io.opentelemetry.proto.metrics.v1.Summary) data_)
              .mergeFrom(value).buildPartial();
        } else {
          data_ = value;
        }
        onChanged();
      } else {
        if (dataCase_ == 11) {
          summaryBuilder_.mergeFrom(value);
        } else {
          summaryBuilder_.setMessage(value);
        }
      }
      dataCase_ = 11;
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    public Builder clearSummary() {
      if (summaryBuilder_ == null) {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
          onChanged();
        }
      } else {
        if (dataCase_ == 11) {
          dataCase_ = 0;
          data_ = null;
        }
        summaryBuilder_.clear();
      }
      return this;
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    public io.opentelemetry.proto.metrics.v1.Summary.Builder getSummaryBuilder() {
      return getSummaryFieldBuilder().getBuilder();
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    @java.lang.Override
    public io.opentelemetry.proto.metrics.v1.SummaryOrBuilder getSummaryOrBuilder() {
      if ((dataCase_ == 11) && (summaryBuilder_ != null)) {
        return summaryBuilder_.getMessageOrBuilder();
      } else {
        if (dataCase_ == 11) {
          return (io.opentelemetry.proto.metrics.v1.Summary) data_;
        }
        return io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
      }
    }
    /**
     * <code>.opentelemetry.proto.metrics.v1.Summary summary = 11;</code>
     */
    private com.google.protobuf.SingleFieldBuilder<
        io.opentelemetry.proto.metrics.v1.Summary, io.opentelemetry.proto.metrics.v1.Summary.Builder, io.opentelemetry.proto.metrics.v1.SummaryOrBuilder> 
        getSummaryFieldBuilder() {
      if (summaryBuilder_ == null) {
        if (!(dataCase_ == 11)) {
          data_ = io.opentelemetry.proto.metrics.v1.Summary.getDefaultInstance();
        }
        summaryBuilder_ = new com.google.protobuf.SingleFieldBuilder<
            io.opentelemetry.proto.metrics.v1.Summary, io.opentelemetry.proto.metrics.v1.Summary.Builder, io.opentelemetry.proto.metrics.v1.SummaryOrBuilder>(
                (io.opentelemetry.proto.metrics.v1.Summary) data_,
                getParentForChildren(),
                isClean());
        data_ = null;
      }
      dataCase_ = 11;
      onChanged();
      return summaryBuilder_;
    }

    private java.util.List<io.opentelemetry.proto.common.v1.KeyValue> metadata_ =
      java.util.Collections.emptyList();
    private void ensureMetadataIsMutable() {
      if (!((bitField0_ & 0x00000100) != 0)) {
        metadata_ = new java.util.ArrayList<io.opentelemetry.proto.common.v1.KeyValue>(metadata_);
        bitField0_ |= 0x00000100;
       }
    }

    private com.google.protobuf.RepeatedFieldBuilder<
        io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder> metadataBuilder_;

    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public java.util.List<io.opentelemetry.proto.common.v1.KeyValue> getMetadataList() {
      if (metadataBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metadata_);
      } else {
        return metadataBuilder_.getMessageList();
      }
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public int getMetadataCount() {
      if (metadataBuilder_ == null) {
        return metadata_.size();
      } else {
        return metadataBuilder_.getCount();
      }
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue getMetadata(int index) {
      if (metadataBuilder_ == null) {
        return metadata_.get(index);
      } else {
        return metadataBuilder_.getMessage(index);
      }
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder setMetadata(
        int index, io.opentelemetry.proto.common.v1.KeyValue value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataIsMutable();
        metadata_.set(index, value);
        onChanged();
      } else {
        metadataBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder setMetadata(
        int index, io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        ensureMetadataIsMutable();
        metadata_.set(index, builderForValue.build());
        onChanged();
      } else {
        metadataBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder addMetadata(io.opentelemetry.proto.common.v1.KeyValue value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataIsMutable();
        metadata_.add(value);
        onChanged();
      } else {
        metadataBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder addMetadata(
        int index, io.opentelemetry.proto.common.v1.KeyValue value) {
      if (metadataBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetadataIsMutable();
        metadata_.add(index, value);
        onChanged();
      } else {
        metadataBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder addMetadata(
        io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        ensureMetadataIsMutable();
        metadata_.add(builderForValue.build());
        onChanged();
      } else {
        metadataBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder addMetadata(
        int index, io.opentelemetry.proto.common.v1.KeyValue.Builder builderForValue) {
      if (metadataBuilder_ == null) {
        ensureMetadataIsMutable();
        metadata_.add(index, builderForValue.build());
        onChanged();
      } else {
        metadataBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder addAllMetadata(
        java.lang.Iterable<? extends io.opentelemetry.proto.common.v1.KeyValue> values) {
      if (metadataBuilder_ == null) {
        ensureMetadataIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(
            values, metadata_);
        onChanged();
      } else {
        metadataBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder clearMetadata() {
      if (metadataBuilder_ == null) {
        metadata_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000100);
        onChanged();
      } else {
        metadataBuilder_.clear();
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public Builder removeMetadata(int index) {
      if (metadataBuilder_ == null) {
        ensureMetadataIsMutable();
        metadata_.remove(index);
        onChanged();
      } else {
        metadataBuilder_.remove(index);
      }
      return this;
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder getMetadataBuilder(
        int index) {
      return getMetadataFieldBuilder().getBuilder(index);
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValueOrBuilder getMetadataOrBuilder(
        int index) {
      if (metadataBuilder_ == null) {
        return metadata_.get(index);  } else {
        return metadataBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public java.util.List<? extends io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
         getMetadataOrBuilderList() {
      if (metadataBuilder_ != null) {
        return metadataBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metadata_);
      }
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder addMetadataBuilder() {
      return getMetadataFieldBuilder().addBuilder(
          io.opentelemetry.proto.common.v1.KeyValue.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public io.opentelemetry.proto.common.v1.KeyValue.Builder addMetadataBuilder(
        int index) {
      return getMetadataFieldBuilder().addBuilder(
          index, io.opentelemetry.proto.common.v1.KeyValue.getDefaultInstance());
    }
    /**
     * <pre>
     * Additional metadata attributes that describe the metric. [Optional].
     * Attributes are non-identifying.
     * Consumers SHOULD NOT need to be aware of these attributes.
     * These attributes MAY be used to encode information allowing
     * for lossless roundtrip translation to / from another data model.
     * Attribute keys MUST be unique (it is not allowed to have more than one
     * attribute with the same key).
     * </pre>
     *
     * <code>repeated .opentelemetry.proto.common.v1.KeyValue metadata = 12;</code>
     */
    public java.util.List<io.opentelemetry.proto.common.v1.KeyValue.Builder> 
         getMetadataBuilderList() {
      return getMetadataFieldBuilder().getBuilderList();
    }
    private com.google.protobuf.RepeatedFieldBuilder<
        io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder> 
        getMetadataFieldBuilder() {
      if (metadataBuilder_ == null) {
        metadataBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
            io.opentelemetry.proto.common.v1.KeyValue, io.opentelemetry.proto.common.v1.KeyValue.Builder, io.opentelemetry.proto.common.v1.KeyValueOrBuilder>(
                metadata_,
                ((bitField0_ & 0x00000100) != 0),
                getParentForChildren(),
                isClean());
        metadata_ = null;
      }
      return metadataBuilder_;
    }

    // @@protoc_insertion_point(builder_scope:opentelemetry.proto.metrics.v1.Metric)
  }

  // @@protoc_insertion_point(class_scope:opentelemetry.proto.metrics.v1.Metric)
  private static final io.opentelemetry.proto.metrics.v1.Metric DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new io.opentelemetry.proto.metrics.v1.Metric();
  }

  public static io.opentelemetry.proto.metrics.v1.Metric getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<Metric>
      PARSER = new com.google.protobuf.AbstractParser<Metric>() {
    @java.lang.Override
    public Metric parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<Metric> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<Metric> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public io.opentelemetry.proto.metrics.v1.Metric getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

