/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.baggage.BaggageField;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.SpanContext;
import java.util.Map;

public abstract class BraveSpanContext
implements SpanContext {
    volatile Span.Kind kind;

    public abstract TraceContext unwrap();

    public abstract Iterable<Map.Entry<String, String>> baggageItems();

    static BraveSpanContext create(TraceContext context) {
        return new Complete(context);
    }

    static BraveSpanContext create(TraceContextOrSamplingFlags extractionResult) {
        return extractionResult.context() != null ? new Complete(extractionResult.context()) : new Incomplete(extractionResult);
    }

    BraveSpanContext() {
    }

    static final class Complete
    extends BraveSpanContext {
        final TraceContext context;

        Complete(TraceContext context) {
            this.context = context;
        }

        @Override
        public TraceContext unwrap() {
            return this.context;
        }

        public String toTraceId() {
            return this.context.traceIdString();
        }

        public String toSpanId() {
            return this.context.spanIdString();
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return BaggageField.getAllValues((TraceContext)this.context).entrySet();
        }
    }

    static final class Incomplete
    extends BraveSpanContext {
        final TraceContextOrSamplingFlags extractionResult;

        Incomplete(TraceContextOrSamplingFlags extractionResult) {
            this.extractionResult = extractionResult;
        }

        TraceContextOrSamplingFlags extractionResult() {
            return this.extractionResult;
        }

        @Override
        public TraceContext unwrap() {
            return this.extractionResult.context();
        }

        public String toTraceId() {
            TraceContext context = this.extractionResult.context();
            return context != null ? context.traceIdString() : null;
        }

        public String toSpanId() {
            TraceContext context = this.extractionResult.context();
            return context != null ? context.spanIdString() : null;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return BaggageField.getAllValues((TraceContextOrSamplingFlags)this.extractionResult).entrySet();
        }
    }
}

