/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Tracing;
import brave.opentracing.BraveScopeManager;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveTracer;
import brave.opentracing.v0_32_BraveScopeManager;
import brave.opentracing.v0_32_BraveSpanBuilder;
import io.opentracing.ScopeManager;
import io.opentracing.Span;

abstract class OpenTracingVersion {
    private static final OpenTracingVersion INSTANCE = OpenTracingVersion.findVersion();

    OpenTracingVersion() {
    }

    static OpenTracingVersion get() {
        return INSTANCE;
    }

    BraveScopeManager scopeManager(Tracing tracing) {
        return new BraveScopeManager(tracing);
    }

    BraveSpanBuilder spanBuilder(BraveTracer braveTracer, String operationName) {
        return new BraveSpanBuilder(braveTracer.tracing, operationName);
    }

    private static OpenTracingVersion findVersion() {
        if (OpenTracingVersion.isV0_31()) {
            throw new UnsupportedOperationException("OpenTracing 0.31 detected. This version is compatible with io.opentracing:opentracing-api 0.32 or 0.33. io.opentracing.brave:brave-opentracing:0.33.13+ works with version 0.31");
        }
        OpenTracingVersion version = v0_32.buildIfSupported();
        if (version != null) {
            return version;
        }
        version = v0_33.buildIfSupported();
        if (version != null) {
            return version;
        }
        throw new UnsupportedOperationException("This is only compatible with io.opentracing:opentracing-api 0.32 or 0.33");
    }

    static boolean isV0_31() {
        try {
            if (ScopeManager.class.getMethod("activate", Span.class, Boolean.TYPE).getAnnotation(Deprecated.class) == null) {
                return true;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    static class v0_32
    extends OpenTracingVersion {
        static v0_32 buildIfSupported() {
            try {
                if (ScopeManager.class.getMethod("activate", Span.class, Boolean.TYPE).getAnnotation(Deprecated.class) != null) {
                    return new v0_32();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            return null;
        }

        @Override
        BraveScopeManager scopeManager(Tracing tracing) {
            return new v0_32_BraveScopeManager(tracing);
        }

        @Override
        BraveSpanBuilder spanBuilder(BraveTracer braveTracer, String operationName) {
            return new v0_32_BraveSpanBuilder(braveTracer.scopeManager, operationName);
        }

        public String toString() {
            return "v0_32{}";
        }

        v0_32() {
        }
    }

    static class v0_33
    extends OpenTracingVersion {
        static v0_33 buildIfSupported() {
            try {
                Class.forName("io.opentracing.tag.Tag");
                return new v0_33();
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        public String toString() {
            return "v0_33{}";
        }

        v0_33() {
        }
    }
}

