/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.Span;
import io.opentracing.contrib.dropwizard.ClientAttribute;
import io.opentracing.contrib.dropwizard.DropWizardTracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;

public class ClientRequestTracingFilter
implements ClientRequestFilter {
    private final Request request;
    private final DropWizardTracer tracer;
    private final Set<ClientAttribute> tracedAttributes;
    private final Set<String> tracedProperties;
    private String operationName;

    public ClientRequestTracingFilter(DropWizardTracer tracer, Request request, String operationName, Set<ClientAttribute> tracedAttributes, Set<String> tracedProperties) {
        this.tracer = tracer;
        this.request = request;
        this.operationName = operationName;
        this.tracedAttributes = tracedAttributes;
        this.tracedProperties = tracedProperties;
    }

    public void filter(ClientRequestContext requestContext) throws IOException {
        Object parentSpan;
        if (this.operationName == "") {
            this.operationName = "Client";
        }
        Span span = null;
        span = this.request != null ? ((parentSpan = this.tracer.getSpan(this.request)) == null ? this.tracer.getTracer().buildSpan(this.operationName).start() : this.tracer.getTracer().buildSpan(this.operationName).asChildOf(parentSpan.context()).start()) : this.tracer.getTracer().buildSpan(this.operationName).start();
        for (ClientAttribute attribute : this.tracedAttributes) {
            switch (attribute) {
                case ACCEPTABLE_LANGUAGES: {
                    try {
                        span.setTag("Acceptable Languages", requestContext.getAcceptableLanguages().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ACCEPTABLE_MEDIA_TYPES: {
                    try {
                        span.setTag("Acceptable Media Types", requestContext.getAcceptableMediaTypes().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case COOKIES: {
                    try {
                        span.setTag("Cookies", requestContext.getCookies().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case DATE: {
                    try {
                        span.setTag("Date", requestContext.getDate().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ENTITY: {
                    try {
                        span.log("Entity", requestContext.getEntity());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ENTITY_ANNOTATIONS: {
                    try {
                        span.setTag("Entity Stream", requestContext.getEntityStream().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ENTITY_CLASS: {
                    try {
                        span.setTag("Entity Class", requestContext.getEntityClass().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ENTITY_STREAM: {
                    try {
                        span.log("Entity Stream", (Object)requestContext.getEntityStream());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case HEADERS: {
                    try {
                        span.setTag("Headers", requestContext.getHeaders().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case LANGUAGE: {
                    try {
                        span.setTag("Language", requestContext.getLanguage().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case MEDIA_TYPE: {
                    try {
                        span.setTag("Media Type", requestContext.getMediaType().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case METHOD: {
                    try {
                        span.setTag("Method", requestContext.getMethod());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case PROPERTY_NAMES: {
                    try {
                        span.setTag("Property Names", requestContext.getPropertyNames().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case URI: {
                    try {
                        span.setTag("URI", requestContext.getUri().toString());
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        for (String propertyName : this.tracedProperties) {
            Object property = requestContext.getProperty(propertyName);
            if (property == null) continue;
            span.log(propertyName, property);
        }
        this.tracer.addClientSpan(requestContext, span);
        final MultivaluedMap headers = requestContext.getHeaders();
        this.tracer.getTracer().inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new TextMap(){

            public void put(String k, String v) {
                headers.putSingle((Object)k, (Object)v);
            }

            public Iterator<Map.Entry<String, String>> iterator() {
                throw new UnsupportedOperationException("iterator should never be used with Tracer.inject()");
            }
        });
    }
}

