/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.contrib.dropwizard.ClientAttribute;
import io.opentracing.contrib.dropwizard.ClientRequestTracingFilter;
import io.opentracing.contrib.dropwizard.ClientResponseTracingFilter;
import io.opentracing.contrib.dropwizard.DropWizardTracer;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Request;
import javax.ws.rs.ext.Provider;

@Provider
public class ClientTracingFeature {
    private final DropWizardTracer tracer;
    private final Request request;
    private final Set<ClientAttribute> tracedAttributes;
    private final Set<String> tracedProperties;
    private final String operationName;

    private ClientTracingFeature(DropWizardTracer tracer, Request request, String operationName, Set<ClientAttribute> tracedAttributes, Set<String> tracedProperties) {
        this.tracer = tracer;
        this.request = request;
        this.operationName = operationName;
        this.tracedAttributes = tracedAttributes;
        this.tracedProperties = tracedProperties;
    }

    public void registerTo(Client client) {
        client.register((Object)new ClientRequestTracingFilter(this.tracer, this.request, this.operationName, this.tracedAttributes, this.tracedProperties));
        client.register((Object)new ClientResponseTracingFilter(this.tracer));
    }

    public void registerTo(WebTarget target) {
        target.register((Object)new ClientRequestTracingFilter(this.tracer, this.request, this.operationName, this.tracedAttributes, this.tracedProperties));
        target.register((Object)new ClientResponseTracingFilter(this.tracer));
    }

    public static class Builder {
        private final DropWizardTracer tracer;
        private Request request;
        private Set<ClientAttribute> tracedAttributes;
        private Set<String> tracedProperties;
        private String operationName;

        public Builder(DropWizardTracer tracer) {
            this.tracer = tracer;
            this.request = null;
            this.tracedAttributes = new HashSet<ClientAttribute>();
            this.tracedProperties = new HashSet<String>();
            this.operationName = "";
        }

        public Builder withRequest(Request request) {
            this.request = request;
            return this;
        }

        public Builder withTracedAttributes(Set<ClientAttribute> tracedAttributes) {
            this.tracedAttributes = tracedAttributes;
            return this;
        }

        public Builder withTracedProperties(Set<String> properties) {
            this.tracedProperties = properties;
            return this;
        }

        public Builder withOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public ClientTracingFeature build() {
            return new ClientTracingFeature(this.tracer, this.request, this.operationName, this.tracedAttributes, this.tracedProperties);
        }
    }
}

