/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.Span;
import io.opentracing.Tracer;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.core.Request;

public class DropWizardTracer {
    private Tracer tracer;
    private Map<Request, Span> serverSpans = new ConcurrentHashMap<Request, Span>();
    private Map<ClientRequestContext, Span> clientSpans = new ConcurrentHashMap<ClientRequestContext, Span>();

    public DropWizardTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public Span getSpan(Request request) {
        return this.serverSpans.get(request);
    }

    public Span getSpan(ClientRequestContext requestCtx) {
        return this.clientSpans.get(requestCtx);
    }

    protected void addServerSpan(Request request, Span span) {
        this.serverSpans.put(request, span);
    }

    protected void addClientSpan(ClientRequestContext requestCtx, Span span) {
        this.clientSpans.put(requestCtx, span);
    }

    protected void finishServerSpan(Request request) {
        Span span = this.serverSpans.get(request);
        if (span != null) {
            this.serverSpans.remove(request);
            span.finish();
        }
    }

    protected void finishClientSpan(ClientRequestContext requestCtx) {
        Span span = this.clientSpans.get(requestCtx);
        if (span != null) {
            this.clientSpans.remove(requestCtx);
            span.finish();
        }
    }
}

