/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.contrib.dropwizard.DropWizardTracer;
import io.opentracing.contrib.dropwizard.RequestSpanDecorator;
import io.opentracing.contrib.dropwizard.ServerAttribute;
import io.opentracing.contrib.dropwizard.ServerTracingFeature;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MultivaluedMap;

public class ServerRequestTracingFilter
implements ContainerRequestFilter {
    private final DropWizardTracer tracer;
    private final Set<ServerAttribute> tracedAttributes;
    private final Set<String> tracedProperties;
    private String operationName;
    private RequestSpanDecorator decorator;

    public ServerRequestTracingFilter(DropWizardTracer tracer, String operationName, Set<ServerAttribute> tracedAttributes, Set<String> tracedProperties, RequestSpanDecorator decorator) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.tracedProperties = tracedProperties;
        this.tracedAttributes = tracedAttributes;
        this.decorator = decorator;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        Span span;
        if (this.operationName.equals("")) {
            for (Object resource : requestContext.getUriInfo().getMatchedResources()) {
                this.operationName = this.operationName + resource.getClass().getSimpleName() + " ";
            }
        }
        MultivaluedMap rawHeaders = requestContext.getHeaders();
        HashMap headers = new HashMap();
        for (String key : rawHeaders.keySet()) {
            headers.put(key, ((List)rawHeaders.get((Object)key)).get(0));
        }
        try {
            SpanContext parentSpan = this.tracer.getTracer().extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headers));
            span = parentSpan == null ? this.tracer.getTracer().buildSpan(this.operationName).start() : this.tracer.getTracer().buildSpan(this.operationName).asChildOf(parentSpan).start();
        }
        catch (IllegalArgumentException e) {
            span = this.tracer.getTracer().buildSpan(this.operationName).start();
        }
        for (ServerAttribute attribute : this.tracedAttributes) {
            switch (attribute) {
                case ACCEPTABLE_LANGUAGES: {
                    try {
                        span.setTag("Acceptable Languages", requestContext.getAcceptableLanguages().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ACCEPTABLE_MEDIA_TYPES: {
                    try {
                        span.setTag("Acceptable Media Types", requestContext.getAcceptableMediaTypes().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case COOKIES: {
                    try {
                        span.setTag("Cookies", requestContext.getCookies().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case DATE: {
                    try {
                        span.setTag("Date", requestContext.getDate().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case ENTITY_STREAM: {
                    try {
                        span.log("Entity Stream", (Object)requestContext.getEntityStream());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case HEADERS: {
                    try {
                        span.setTag("Headers", requestContext.getHeaders().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case LANGUAGE: {
                    try {
                        span.setTag("Language", requestContext.getLanguage().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case CONTENT_LENGTH: {
                    try {
                        span.setTag("Content Length", (Number)requestContext.getLength());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case METHOD: {
                    try {
                        span.setTag("Method", requestContext.getMethod());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case MEDIA_TYPE: {
                    try {
                        span.setTag("Media Type", requestContext.getMediaType().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case PROPERTY_NAMES: {
                    try {
                        span.setTag("Property Names", requestContext.getPropertyNames().toString());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case SECURITY_CONTEXT: {
                    try {
                        span.setTag("Security Context", requestContext.getSecurityContext().getAuthenticationScheme());
                    }
                    catch (NullPointerException nullPointerException) {}
                    break;
                }
                case URI: {
                    try {
                        span.setTag("URI", requestContext.getUriInfo().getAbsolutePath().toString());
                        break;
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                }
            }
        }
        for (String propertyName : this.tracedProperties) {
            Object property = requestContext.getProperty(propertyName);
            if (property == null) continue;
            span.log(propertyName, property);
        }
        if (this.decorator != null) {
            this.decorator.decorate(requestContext, span);
        }
        this.tracer.addServerSpan(requestContext.getRequest(), span);
        ServerTracingFeature.threadLocalRequestSpan.set(span);
    }
}

