/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.contrib.dropwizard.DropWizardTracer;
import io.opentracing.contrib.dropwizard.ServerTracingFeature;
import java.io.IOException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;

public class ServerResponseTracingFilter
implements ContainerResponseFilter {
    private DropWizardTracer tracer;

    public ServerResponseTracingFilter(DropWizardTracer tracer) {
        this.tracer = tracer;
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        this.tracer.finishServerSpan(requestContext.getRequest());
        ServerTracingFeature.threadLocalRequestSpan.set(null);
    }

    public class Builder {
        private DropWizardTracer tracer;

        public Builder(DropWizardTracer tracer) {
            this.tracer = tracer;
        }

        public ServerResponseTracingFilter build() {
            return new ServerResponseTracingFilter(this.tracer);
        }
    }
}

