/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.dropwizard;

import io.opentracing.Span;
import io.opentracing.contrib.dropwizard.DropWizardTracer;
import io.opentracing.contrib.dropwizard.RequestSpanDecorator;
import io.opentracing.contrib.dropwizard.ServerAttribute;
import io.opentracing.contrib.dropwizard.ServerRequestTracingFilter;
import io.opentracing.contrib.dropwizard.ServerResponseTracingFilter;
import io.opentracing.contrib.dropwizard.Trace;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.ext.Provider;

@Provider
public class ServerTracingFeature
implements DynamicFeature {
    private final DropWizardTracer tracer;
    private final Set<ServerAttribute> tracedAttributes;
    private final Set<String> tracedProperties;
    private final boolean traceAll;
    private final String operationName;
    private final RequestSpanDecorator decorator;
    static ThreadLocal<Span> threadLocalRequestSpan = new ThreadLocal();

    private ServerTracingFeature(DropWizardTracer tracer, String operationName, Set<ServerAttribute> tracedAttributes, Set<String> tracedProperties, boolean traceAll, RequestSpanDecorator decorator) {
        this.tracer = tracer;
        this.operationName = operationName;
        this.tracedAttributes = tracedAttributes;
        this.tracedProperties = tracedProperties;
        this.traceAll = traceAll;
        this.decorator = decorator;
    }

    public void configure(ResourceInfo resourceInfo, FeatureContext context) {
        Trace annotation = resourceInfo.getResourceMethod().getAnnotation(Trace.class);
        String operationName = this.operationName;
        if (annotation != null) {
            if (!annotation.operationName().equals("")) {
                operationName = annotation.operationName();
            }
            context.register((Object)new ServerRequestTracingFilter(this.tracer, operationName, this.tracedAttributes, this.tracedProperties, this.decorator));
            context.register((Object)new ServerResponseTracingFilter(this.tracer));
        } else if (this.traceAll) {
            context.register((Object)new ServerRequestTracingFilter(this.tracer, operationName, this.tracedAttributes, this.tracedProperties, this.decorator));
            context.register((Object)new ServerResponseTracingFilter(this.tracer));
        }
    }

    public static Span getThreadLocalRequestSpan() {
        return threadLocalRequestSpan.get();
    }

    public static class Builder {
        private final DropWizardTracer tracer;
        private Set<ServerAttribute> tracedAttributes;
        private Set<String> tracedProperties;
        private boolean traceAll;
        private String operationName;
        private RequestSpanDecorator decorator;

        public Builder(DropWizardTracer tracer) {
            this.tracer = tracer;
            this.tracedAttributes = new HashSet<ServerAttribute>();
            this.tracedProperties = new HashSet<String>();
            this.traceAll = true;
            this.operationName = "";
        }

        public Builder withTracedAttributes(Set<ServerAttribute> tracedAttributes) {
            this.tracedAttributes = tracedAttributes;
            return this;
        }

        public Builder withTracedProperties(Set<String> properties) {
            this.tracedProperties = properties;
            return this;
        }

        public Builder withTraceAnnotations() {
            this.traceAll = false;
            return this;
        }

        public Builder withRequestSpanDecorator(RequestSpanDecorator decorator) {
            this.decorator = decorator;
            return this;
        }

        public Builder withOperationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public ServerTracingFeature build() {
            return new ServerTracingFeature(this.tracer, this.operationName, this.tracedAttributes, this.tracedProperties, this.traceAll, this.decorator);
        }
    }
}

