/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.apache.http.client;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.apache.http.client.ApacheClientSpanDecorator;
import io.opentracing.contrib.apache.http.client.Constants;
import io.opentracing.contrib.apache.http.client.HttpHeadersInjectAdapter;
import io.opentracing.contrib.apache.http.client.TracingHttpClientBuilder;
import io.opentracing.contrib.spanmanager.DefaultSpanManager;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpExecutionAware;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.execchain.ClientExecChain;
import org.apache.http.protocol.HttpContext;

public class TracingClientExec
implements ClientExecChain {
    static final String COMPONENT_NAME = "apache-httpclient";
    protected static final String ACTIVE_SPAN = TracingHttpClientBuilder.class.getName() + ".activeSpan";
    protected static final String REDIRECT_COUNT = TracingHttpClientBuilder.class.getName() + ".redirectCount";
    private final RedirectStrategy redirectStrategy;
    private final ClientExecChain requestExecutor;
    private final boolean redirectHandlingDisabled;
    private final Tracer tracer;
    private final SpanManager spanManager = DefaultSpanManager.getInstance();
    private final List<ApacheClientSpanDecorator> spanDecorators;

    public TracingClientExec(ClientExecChain clientExecChain, RedirectStrategy redirectStrategy, boolean redirectHandlingDisabled, Tracer tracer, List<ApacheClientSpanDecorator> spanDecorators) {
        this.requestExecutor = clientExecChain;
        this.redirectStrategy = redirectStrategy;
        this.redirectHandlingDisabled = redirectHandlingDisabled;
        this.tracer = tracer;
        this.spanDecorators = new ArrayList<ApacheClientSpanDecorator>(spanDecorators);
    }

    public CloseableHttpResponse execute(HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        Span localSpan = (Span)clientContext.getAttribute(ACTIVE_SPAN, Span.class);
        CloseableHttpResponse response = null;
        try {
            if (localSpan == null) {
                localSpan = this.handleLocalSpan((HttpRequest)request, clientContext);
            }
            CloseableHttpResponse closeableHttpResponse = response = this.handleNetworkProcessing(localSpan, route, request, clientContext, execAware);
            return closeableHttpResponse;
        }
        catch (Exception e) {
            localSpan.finish();
            throw e;
        }
        finally {
            if (response != null) {
                Integer redirectCount = (Integer)clientContext.getAttribute(REDIRECT_COUNT, Integer.class);
                if (!this.redirectHandlingDisabled && clientContext.getRequestConfig().isRedirectsEnabled() && this.redirectStrategy.isRedirected((HttpRequest)request, (HttpResponse)response, (HttpContext)clientContext) && (redirectCount = Integer.valueOf(redirectCount + 1)) < clientContext.getRequestConfig().getMaxRedirects()) {
                    clientContext.setAttribute(REDIRECT_COUNT, (Object)redirectCount);
                } else {
                    localSpan.finish();
                }
            }
        }
    }

    protected Span handleLocalSpan(HttpRequest httpRequest, HttpClientContext clientContext) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(httpRequest.getRequestLine().getMethod()).withTag(Tags.COMPONENT.getKey(), COMPONENT_NAME);
        if (clientContext.getAttribute(Constants.PARENT_CONTEXT, SpanContext.class) != null) {
            spanBuilder.asChildOf((SpanContext)clientContext.getAttribute(Constants.PARENT_CONTEXT, SpanContext.class));
        } else if (this.spanManager.current().getSpan() != null) {
            spanBuilder.asChildOf(this.spanManager.current().getSpan());
        }
        Span localSpan = spanBuilder.start();
        clientContext.setAttribute(ACTIVE_SPAN, (Object)localSpan);
        clientContext.setAttribute(REDIRECT_COUNT, (Object)0);
        return localSpan;
    }

    protected CloseableHttpResponse handleNetworkProcessing(Span parentSpan, HttpRoute route, HttpRequestWrapper request, HttpClientContext clientContext, HttpExecutionAware execAware) throws IOException, HttpException {
        Span redirectSpan = this.tracer.buildSpan(request.getMethod()).withTag(Tags.SPAN_KIND.getKey(), "client").asChildOf(parentSpan).start();
        this.tracer.inject(redirectSpan.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersInjectAdapter((HttpRequest)request));
        try {
            for (ApacheClientSpanDecorator decorator : this.spanDecorators) {
                decorator.onRequest(request, (HttpContext)clientContext, redirectSpan);
            }
            CloseableHttpResponse response = this.requestExecutor.execute(route, request, clientContext, execAware);
            for (ApacheClientSpanDecorator decorator : this.spanDecorators) {
                decorator.onResponse((HttpResponse)response, (HttpContext)clientContext, redirectSpan);
            }
            CloseableHttpResponse closeableHttpResponse = response;
            return closeableHttpResponse;
        }
        catch (IOException | RuntimeException | HttpException e) {
            for (ApacheClientSpanDecorator decorator : this.spanDecorators) {
                decorator.onError((HttpRequest)request, (HttpContext)clientContext, (Exception)e, redirectSpan);
            }
            throw e;
        }
        finally {
            redirectSpan.finish();
        }
    }
}

