/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.apache.http.client;

import io.opentracing.BaseSpan;
import io.opentracing.tag.Tags;
import java.net.URI;
import java.util.HashMap;
import java.util.logging.Logger;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpRequestWrapper;
import org.apache.http.protocol.HttpContext;

public interface ApacheClientSpanDecorator {
    public void onRequest(HttpRequestWrapper var1, HttpContext var2, BaseSpan<?> var3);

    public void onResponse(HttpResponse var1, HttpContext var2, BaseSpan<?> var3);

    public void onError(HttpRequest var1, HttpContext var2, Exception var3, BaseSpan<?> var4);

    public static class StandardTags
    implements ApacheClientSpanDecorator {
        private static final Logger log = Logger.getLogger(StandardTags.class.getName());

        @Override
        public void onRequest(HttpRequestWrapper request, HttpContext httpContext, BaseSpan<?> span) {
            Tags.HTTP_METHOD.set(span, request.getRequestLine().getMethod());
            URI uri = request.getURI();
            Tags.HTTP_URL.set(span, request.getRequestLine().getUri());
            Tags.PEER_PORT.set(span, Integer.valueOf(uri.getPort() == -1 ? 80 : uri.getPort()));
            Tags.PEER_HOSTNAME.set(span, uri.getHost());
        }

        @Override
        public void onResponse(HttpResponse response, HttpContext httpContext, BaseSpan<?> span) {
            Tags.HTTP_STATUS.set(span, Integer.valueOf(response.getStatusLine().getStatusCode()));
        }

        @Override
        public void onError(HttpRequest request, HttpContext httpContext, Exception ex, BaseSpan<?> span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", Tags.ERROR.getKey());
            errorLogs.put("error.object", ex);
            span.log(errorLogs);
        }
    }
}

