/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.aws;

import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.handlers.RequestHandler2;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.aws.SpanDecorator;
import io.opentracing.tag.Tags;

public class TracingRequestHandler
extends RequestHandler2 {
    private final HandlerContextKey<Span> contextKey = new HandlerContextKey("span");
    private final SpanContext parentContext;
    private final Tracer tracer;

    public TracingRequestHandler(Tracer tracer) {
        this.parentContext = null;
        this.tracer = tracer;
    }

    public TracingRequestHandler(SpanContext parentContext, Tracer tracer) {
        this.parentContext = parentContext;
        this.tracer = tracer;
    }

    public void beforeRequest(Request<?> request) {
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(request.getOriginalRequest().getClass().getSimpleName()).withTag(Tags.SPAN_KIND.getKey(), "client");
        if (this.parentContext != null) {
            spanBuilder.asChildOf(this.parentContext);
        }
        Span span = spanBuilder.start();
        SpanDecorator.onRequest(request, span);
        request.addHandlerContext(this.contextKey, (Object)span);
    }

    public void afterResponse(Request<?> request, Response<?> response) {
        Span span = (Span)request.getHandlerContext(this.contextKey);
        SpanDecorator.onResponse(response, span);
        span.finish();
    }

    public void afterError(Request<?> request, Response<?> response, Exception e) {
        Span span = (Span)request.getHandlerContext(this.contextKey);
        SpanDecorator.onError(e, span);
        span.finish();
    }
}

