/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.cassandra;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Session;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.opentracing.Tracer;
import io.opentracing.contrib.cassandra.TracingSession;
import io.opentracing.contrib.cassandra.nameprovider.CustomStringSpanName;
import io.opentracing.contrib.cassandra.nameprovider.QuerySpanNameProvider;

public class TracingCluster
extends Cluster {
    private final Tracer tracer;
    private final QuerySpanNameProvider querySpanNameProvider;

    public TracingCluster(Cluster.Initializer initializer, Tracer tracer) {
        super(initializer);
        this.tracer = tracer;
        this.querySpanNameProvider = CustomStringSpanName.newBuilder().build("execute");
    }

    public TracingCluster(Cluster.Initializer initializer, Tracer tracer, QuerySpanNameProvider querySpanNameProvider) {
        super(initializer);
        this.tracer = tracer;
        this.querySpanNameProvider = querySpanNameProvider;
    }

    public Session newSession() {
        return new TracingSession(super.newSession(), this.tracer, this.querySpanNameProvider);
    }

    public Session connect() {
        return super.connect();
    }

    public Session connect(String keyspace) {
        return super.connect(keyspace);
    }

    public ListenableFuture<Session> connectAsync() {
        return super.connectAsync();
    }

    public ListenableFuture<Session> connectAsync(String keyspace) {
        return Futures.transform((ListenableFuture)super.connectAsync(keyspace), (Function)new Function<Session, Session>(){

            public Session apply(Session session) {
                return new TracingSession(session, TracingCluster.this.tracer, TracingCluster.this.querySpanNameProvider);
            }
        });
    }
}

