/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.cassandra;

import com.datastax.driver.core.BoundStatement;
import com.datastax.driver.core.CloseFuture;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.RegularStatement;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.Statement;
import com.google.common.base.Function;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.cassandra.nameprovider.CustomStringSpanName;
import io.opentracing.contrib.cassandra.nameprovider.QuerySpanNameProvider;
import io.opentracing.tag.Tags;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class TracingSession
implements Session {
    static final String COMPONENT_NAME = "java-cassandra";
    private final ExecutorService executorService = Executors.newCachedThreadPool();
    private final Session session;
    private final Tracer tracer;
    private final QuerySpanNameProvider querySpanNameProvider;

    TracingSession(Session session, Tracer tracer) {
        this.session = session;
        this.tracer = tracer;
        this.querySpanNameProvider = CustomStringSpanName.newBuilder().build("execute");
    }

    TracingSession(Session session, Tracer tracer, QuerySpanNameProvider querySpanNameProvider) {
        this.session = session;
        this.tracer = tracer;
        this.querySpanNameProvider = querySpanNameProvider;
    }

    public String getLoggedKeyspace() {
        return this.session.getLoggedKeyspace();
    }

    public Session init() {
        return new TracingSession(this.session.init(), this.tracer);
    }

    public ListenableFuture<Session> initAsync() {
        return Futures.transform((ListenableFuture)this.session.initAsync(), (Function)new Function<Session, Session>(){

            public Session apply(Session session) {
                return new TracingSession(session, TracingSession.this.tracer);
            }
        });
    }

    public ResultSet execute(String query) {
        Span span = this.buildSpan(query);
        try {
            ResultSet resultSet = this.session.execute(query);
            TracingSession.finishSpan(span, resultSet);
            return resultSet;
        }
        catch (Exception e) {
            TracingSession.finishSpan(span, e);
            throw e;
        }
    }

    public ResultSet execute(String query, Object ... values) {
        Span span = this.buildSpan(query);
        try {
            ResultSet resultSet = this.session.execute(query, values);
            TracingSession.finishSpan(span, resultSet);
            return resultSet;
        }
        catch (Exception e) {
            TracingSession.finishSpan(span, e);
            throw e;
        }
    }

    public ResultSet execute(String query, Map<String, Object> values) {
        Span span = this.buildSpan(query);
        try {
            ResultSet resultSet = this.session.execute(query, values);
            TracingSession.finishSpan(span, resultSet);
            return resultSet;
        }
        catch (Exception e) {
            TracingSession.finishSpan(span, e);
            throw e;
        }
    }

    public ResultSet execute(Statement statement) {
        String query = TracingSession.getQuery(statement);
        Span span = this.buildSpan(query);
        ResultSet resultSet = null;
        try {
            resultSet = this.session.execute(statement);
            TracingSession.finishSpan(span, resultSet);
            return resultSet;
        }
        catch (Exception e) {
            TracingSession.finishSpan(span, e);
            throw e;
        }
    }

    public ResultSetFuture executeAsync(String query) {
        Span span = this.buildSpan(query);
        ResultSetFuture future = this.session.executeAsync(query);
        future.addListener(TracingSession.createListener(span, future), (Executor)this.executorService);
        return future;
    }

    public ResultSetFuture executeAsync(String query, Object ... values) {
        Span span = this.buildSpan(query);
        ResultSetFuture future = this.session.executeAsync(query, values);
        future.addListener(TracingSession.createListener(span, future), (Executor)this.executorService);
        return future;
    }

    public ResultSetFuture executeAsync(String query, Map<String, Object> values) {
        Span span = this.buildSpan(query);
        ResultSetFuture future = this.session.executeAsync(query, values);
        future.addListener(TracingSession.createListener(span, future), (Executor)this.executorService);
        return future;
    }

    public ResultSetFuture executeAsync(Statement statement) {
        String query = TracingSession.getQuery(statement);
        Span span = this.buildSpan(query);
        ResultSetFuture future = this.session.executeAsync(statement);
        future.addListener(TracingSession.createListener(span, future), (Executor)this.executorService);
        return future;
    }

    public PreparedStatement prepare(String query) {
        return this.session.prepare(query);
    }

    public PreparedStatement prepare(RegularStatement statement) {
        return this.session.prepare(statement);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(String query) {
        return this.session.prepareAsync(query);
    }

    public ListenableFuture<PreparedStatement> prepareAsync(RegularStatement statement) {
        return this.session.prepareAsync(statement);
    }

    public CloseFuture closeAsync() {
        return this.session.closeAsync();
    }

    public void close() {
        this.session.close();
    }

    public boolean isClosed() {
        return this.session.isClosed();
    }

    public Cluster getCluster() {
        return this.session.getCluster();
    }

    public Session.State getState() {
        return this.session.getState();
    }

    private static String getQuery(Statement statement) {
        String query = null;
        if (statement instanceof BoundStatement) {
            query = ((BoundStatement)statement).preparedStatement().getQueryString();
        } else if (statement instanceof RegularStatement) {
            query = ((RegularStatement)statement).getQueryString();
        }
        return query == null ? "" : query;
    }

    private static Runnable createListener(final Span span, final ResultSetFuture future) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    TracingSession.finishSpan(span, (ResultSet)future.get());
                }
                catch (InterruptedException | ExecutionException e) {
                    TracingSession.finishSpan(span, e);
                }
            }
        };
    }

    private Span buildSpan(String query) {
        String querySpanName = this.querySpanNameProvider.querySpanName(query);
        Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan(querySpanName).withTag(Tags.SPAN_KIND.getKey(), "client");
        Span span = spanBuilder.start();
        Tags.COMPONENT.set(span, COMPONENT_NAME);
        Tags.DB_STATEMENT.set(span, query);
        Tags.DB_TYPE.set(span, "cassandra");
        String keyspace = this.getLoggedKeyspace();
        if (keyspace != null) {
            Tags.DB_INSTANCE.set(span, keyspace);
        }
        return span;
    }

    private static void finishSpan(Span span, ResultSet resultSet) {
        if (resultSet != null) {
            Host host = resultSet.getExecutionInfo().getQueriedHost();
            Tags.PEER_PORT.set(span, Integer.valueOf(host.getSocketAddress().getPort()));
            Tags.PEER_HOSTNAME.set(span, host.getAddress().getHostName());
            InetAddress inetAddress = host.getSocketAddress().getAddress();
            if (inetAddress instanceof Inet4Address) {
                byte[] address = inetAddress.getAddress();
                Tags.PEER_HOST_IPV4.set(span, Integer.valueOf(ByteBuffer.wrap(address).getInt()));
            } else {
                Tags.PEER_HOST_IPV6.set(span, inetAddress.getHostAddress());
            }
        }
        span.finish();
    }

    private static void finishSpan(Span span, Exception e) {
        Tags.ERROR.set(span, Boolean.TRUE);
        span.log(TracingSession.errorLogs(e));
        span.finish();
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(4);
        errorLogs.put("event", Tags.ERROR.getKey());
        errorLogs.put("error.kind", throwable.getClass().getName());
        errorLogs.put("error.object", throwable);
        errorLogs.put("message", throwable.getMessage());
        StringWriter sw = new StringWriter();
        throwable.printStackTrace(new PrintWriter(sw));
        errorLogs.put("stack", sw.toString());
        return errorLogs;
    }
}

