/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.cassandra.nameprovider;

import io.opentracing.contrib.cassandra.nameprovider.QuerySpanNameProvider;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class QueryMethodTableSpanName
implements QuerySpanNameProvider {
    private final String[] CASSANDRA_MANIPULATION_METHODS = new String[]{"BATCH", "SELECT", "INSERT", "UPDATE", "DELETE"};
    private final String[] CASSANDRA_DEFINITION_METHODS = new String[]{"CREATE KEYSPACE", "USE", "ALTER KEYSPACE", "DROP KEYSPACE", "CREATE TABLE", "ALTER TABLE", "DROP TABLE", "TRUNCATE", "CREATE INDEX", "DROP INDEX", "CREATE MATERIALIZED VIEW", "ALTER MATERIALIZED VIEW", "DROP MATERIALIZED VIEW"};

    QueryMethodTableSpanName() {
    }

    @Override
    public String querySpanName(String query) {
        if (query == null || query.equals("")) {
            return "Cassandra";
        }
        String queryTable = "N/A";
        ManipulationMethod manipulationMethod = this.getManipulationMethod(query);
        String queryMethod = manipulationMethod.toString();
        if (!manipulationMethod.equals((Object)ManipulationMethod.NOT_FOUND)) {
            switch (manipulationMethod) {
                case SELECT: 
                case DELETE: {
                    queryTable = this.findTargetEntityAfter(query, "FROM");
                    break;
                }
                case INSERT: {
                    queryTable = this.findTargetEntityAfter(query, "INTO");
                    break;
                }
                case UPDATE: {
                    queryTable = this.findTargetEntityAfter(query, "UPDATE");
                    break;
                }
                case BATCH: {
                    return String.format("Cassandra.%s", queryMethod);
                }
                default: {
                    return "Cassandra";
                }
            }
            return String.format("Cassandra.%s - %s", manipulationMethod.toString(), queryTable);
        }
        DefinitionMethod definitionMethod = this.getDefininitionMethod(query);
        queryMethod = definitionMethod.toString().replace("_", " ");
        if (!definitionMethod.equals((Object)DefinitionMethod.NOT_FOUND)) {
            switch (definitionMethod) {
                case USE: 
                case ALTER_KEYSPACE: 
                case ALTER_MATERIALIZED_VIEW: 
                case ALTER_TABLE: {
                    queryTable = this.findTargetEntityAfter(query, queryMethod);
                    break;
                }
                case DROP_INDEX: 
                case DROP_KEYSPACE: 
                case DROP_MATERIALIZED_VIEW: 
                case DROP_TABLE: {
                    queryTable = this.findTargetEntityAfter(query, queryMethod + " IF EXISTS");
                    if (!queryTable.equals("N/A")) break;
                    queryTable = this.findTargetEntityAfter(query, queryMethod);
                    break;
                }
                case CREATE_INDEX: 
                case CREATE_KEYSPACE: 
                case CREATE_MATERIALIZED_VIEW: 
                case CREATE_TABLE: {
                    queryTable = this.findTargetEntityAfter(query, queryMethod + " IF NOT EXISTS");
                    if (!queryTable.equals("N/A")) break;
                    queryTable = this.findTargetEntityAfter(query, queryMethod);
                    break;
                }
                case TRUNCATE: {
                    queryTable = this.findTargetEntityAfter(query, queryMethod + " TABLE");
                    if (!queryTable.equals("N/A")) break;
                    queryTable = this.findTargetEntityAfter(query, queryMethod);
                }
            }
            return String.format("Cassandra.%s - %s", definitionMethod.toString(), queryTable);
        }
        return "Cassandra";
    }

    private ManipulationMethod getManipulationMethod(String query) {
        String[] queryParts;
        for (String queryPart : queryParts = query.toUpperCase().split("\\s+")) {
            for (String method : this.CASSANDRA_MANIPULATION_METHODS) {
                if (!queryPart.contains(method)) continue;
                return ManipulationMethod.valueOf(method);
            }
        }
        return ManipulationMethod.NOT_FOUND;
    }

    private DefinitionMethod getDefininitionMethod(String query) {
        String upperQuery = query.toUpperCase().replaceAll("\\s{2,}", " ").trim();
        for (String method : this.CASSANDRA_DEFINITION_METHODS) {
            if (!upperQuery.startsWith(method)) continue;
            return DefinitionMethod.valueOf(method.replace(' ', '_'));
        }
        return DefinitionMethod.NOT_FOUND;
    }

    private String findTargetEntityAfter(String query, String after) {
        Pattern findTablePattern = Pattern.compile(Pattern.quote(after) + " ([\\w.]+)");
        Matcher matcher = findTablePattern.matcher(query.replaceAll("\\s{2,}", " "));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "N/A";
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static enum DefinitionMethod {
        CREATE_KEYSPACE,
        USE,
        ALTER_KEYSPACE,
        DROP_KEYSPACE,
        CREATE_TABLE,
        ALTER_TABLE,
        DROP_TABLE,
        TRUNCATE,
        CREATE_INDEX,
        DROP_INDEX,
        CREATE_MATERIALIZED_VIEW,
        ALTER_MATERIALIZED_VIEW,
        DROP_MATERIALIZED_VIEW,
        NOT_FOUND;

    }

    static enum ManipulationMethod {
        SELECT,
        INSERT,
        UPDATE,
        DELETE,
        BATCH,
        NOT_FOUND;

    }

    public static class Builder
    implements QuerySpanNameProvider.Builder {
        @Override
        public QuerySpanNameProvider build() {
            return new QueryMethodTableSpanName();
        }
    }
}

