/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.ActiveSpan;
import io.opentracing.NoopActiveSpanSource;
import java.util.concurrent.Callable;

public class TracedCallable<V>
implements Callable<V> {
    private final Callable<V> delegate;
    private final ActiveSpan.Continuation continuation;

    public TracedCallable(Callable<V> delegate, ActiveSpan activeSpan) {
        this.delegate = delegate;
        this.continuation = activeSpan != null ? activeSpan.capture() : NoopActiveSpanSource.NoopContinuation.INSTANCE;
    }

    @Override
    public V call() throws Exception {
        ActiveSpan activeSpan = this.continuation.activate();
        try {
            V v = this.delegate.call();
            return v;
        }
        finally {
            activeSpan.close();
        }
    }
}

