/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedExecutor;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class TracedExecutorService
extends TracedExecutor
implements ExecutorService {
    private final ExecutorService delegate;

    public TracedExecutorService(ExecutorService delegate, Tracer tracer) {
        super(delegate, tracer);
        this.delegate = delegate;
    }

    @Override
    public void shutdown() {
        this.delegate.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.delegate.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.delegate.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.delegate.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.awaitTermination(l, timeUnit);
    }

    @Override
    public <T> Future<T> submit(Callable<T> callable) {
        return this.delegate.submit(new TracedCallable<T>(callable, this.tracer.activeSpan()));
    }

    @Override
    public <T> Future<T> submit(Runnable runnable, T t) {
        return this.delegate.submit(new TracedRunnable(runnable, this.tracer.activeSpan()), t);
    }

    @Override
    public Future<?> submit(Runnable runnable) {
        return this.delegate.submit(new TracedRunnable(runnable, this.tracer.activeSpan()));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection) throws InterruptedException {
        return this.delegate.invokeAll(this.toTraced(collection));
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.invokeAll(this.toTraced(collection), l, timeUnit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection) throws InterruptedException, ExecutionException {
        return this.delegate.invokeAny(this.toTraced(collection));
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> collection, long l, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.delegate.invokeAny(this.toTraced(collection), l, timeUnit);
    }

    private <T> Collection<? extends Callable<T>> toTraced(Collection<? extends Callable<T>> delegate) {
        ArrayList<TracedCallable<T>> tracedCallables = new ArrayList<TracedCallable<T>>(delegate.size());
        for (Callable<T> callable : delegate) {
            tracedCallables.add(new TracedCallable<T>(callable, this.tracer.activeSpan()));
        }
        return tracedCallables;
    }
}

