/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.ActiveSpan;
import io.opentracing.NoopActiveSpanSource;

public class TracedRunnable
implements Runnable {
    private final Runnable delegate;
    private final ActiveSpan.Continuation continuation;

    public TracedRunnable(Runnable delegate, ActiveSpan activeSpan) {
        this.delegate = delegate;
        this.continuation = activeSpan != null ? activeSpan.capture() : NoopActiveSpanSource.NoopContinuation.INSTANCE;
    }

    @Override
    public void run() {
        ActiveSpan activeSpan = this.continuation.activate();
        try {
            this.delegate.run();
        }
        finally {
            activeSpan.close();
        }
    }
}

