/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.concurrent;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import io.opentracing.contrib.concurrent.TracedExecutorService;
import io.opentracing.contrib.concurrent.TracedRunnable;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class TracedScheduledExecutorService
extends TracedExecutorService
implements ScheduledExecutorService {
    private final ScheduledExecutorService delegate;

    public TracedScheduledExecutorService(ScheduledExecutorService delegate, Tracer tracer) {
        super(delegate, tracer);
        this.delegate = delegate;
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable runnable, long delay, TimeUnit timeUnit) {
        return this.delegate.schedule(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), delay, timeUnit);
    }

    public <T> ScheduledFuture<T> schedule(Callable<T> callable, long delay, TimeUnit timeUnit) {
        return this.delegate.schedule(this.tracer.activeSpan() == null ? callable : new TracedCallable(callable, this.tracer), delay, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable runnable, long initialDelay, long period, TimeUnit timeUnit) {
        return this.delegate.scheduleAtFixedRate(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), initialDelay, period, timeUnit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable runnable, long initialDelay, long delay, TimeUnit timeUnit) {
        return this.delegate.scheduleWithFixedDelay(this.tracer.activeSpan() == null ? runnable : new TracedRunnable(runnable, this.tracer), initialDelay, delay, timeUnit);
    }
}

