/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCall;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.GrpcTags;
import io.opentracing.contrib.grpc.OpenTracingContextKey;
import io.opentracing.contrib.grpc.OperationNameConstructor;
import io.opentracing.contrib.grpc.ServerCloseDecorator;
import io.opentracing.contrib.grpc.ServerSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServerTracingInterceptor
implements ServerInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ServerRequestAttribute> tracedAttributes;
    private final ServerSpanDecorator serverSpanDecorator;
    private final ServerCloseDecorator serverCloseDecorator;

    public ServerTracingInterceptor() {
        this(GlobalTracer.get());
    }

    public ServerTracingInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.operationNameConstructor = OperationNameConstructor.DEFAULT;
        this.streaming = false;
        this.verbose = false;
        this.tracedAttributes = new HashSet<ServerRequestAttribute>();
        this.serverSpanDecorator = null;
        this.serverCloseDecorator = null;
    }

    private ServerTracingInterceptor(Tracer tracer, OperationNameConstructor operationNameConstructor, boolean streaming, boolean verbose, Set<ServerRequestAttribute> tracedAttributes, ServerSpanDecorator serverSpanDecorator, ServerCloseDecorator serverCloseDecorator) {
        this.tracer = tracer;
        this.operationNameConstructor = operationNameConstructor;
        this.streaming = streaming;
        this.verbose = verbose;
        this.tracedAttributes = tracedAttributes;
        this.serverSpanDecorator = serverSpanDecorator;
        this.serverCloseDecorator = serverCloseDecorator;
    }

    public ServerServiceDefinition intercept(ServerServiceDefinition serviceDef) {
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public ServerServiceDefinition intercept(BindableService bindableService) {
        return ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Set headerKeys = headers.keys();
        HashMap<String, String> headerMap = new HashMap<String, String>(headerKeys.size());
        for (String key : headerKeys) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        String operationName = this.operationNameConstructor.constructOperationName(call.getMethodDescriptor());
        final Span span = this.getSpanFromHeaders(headerMap, operationName);
        if (this.serverSpanDecorator != null) {
            this.serverSpanDecorator.interceptCall(span, call, headers);
        }
        for (ServerRequestAttribute attr : this.tracedAttributes) {
            switch (attr) {
                case METHOD_TYPE: {
                    span.setTag("grpc.method_type", call.getMethodDescriptor().getType().toString());
                    break;
                }
                case METHOD_NAME: {
                    span.setTag("grpc.method_name", call.getMethodDescriptor().getFullMethodName());
                    break;
                }
                case CALL_ATTRIBUTES: {
                    span.setTag("grpc.call_attributes", call.getAttributes().toString());
                    break;
                }
                case HEADERS: {
                    span.setTag("grpc.headers", headers.toString());
                    break;
                }
                case PEER_ADDRESS: {
                    GrpcTags.setPeerAddressTag(span, call.getAttributes());
                }
            }
        }
        Context ctxWithSpan = Context.current().withValue(OpenTracingContextKey.getKey(), (Object)span).withValue(OpenTracingContextKey.getSpanContextKey(), (Object)span.context());
        ForwardingServerCall.SimpleForwardingServerCall decoratedCall = new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void close(Status status, Metadata trailers) {
                GrpcTags.setStatusTags(span, status);
                if (ServerTracingInterceptor.this.serverCloseDecorator != null) {
                    ServerTracingInterceptor.this.serverCloseDecorator.close(span, status, trailers);
                }
                super.close(status, trailers);
            }
        };
        ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, (ServerCall)decoratedCall, (Metadata)headers, next);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listenerWithContext){

            public void onMessage(ReqT message) {
                if (ServerTracingInterceptor.this.streaming || ServerTracingInterceptor.this.verbose) {
                    span.log((Map)ImmutableMap.of((Object)"Message received", message));
                }
                try (Scope ignored = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, false);){
                    this.delegate().onMessage(message);
                }
            }

            public void onHalfClose() {
                if (ServerTracingInterceptor.this.streaming) {
                    span.log("Client finished sending messages");
                }
                try (Scope ignored = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, false);){
                    this.delegate().onHalfClose();
                }
            }

            public void onCancel() {
                try (Scope ignored = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, true);){
                    span.log("Call cancelled");
                    this.delegate().onCancel();
                }
            }

            public void onComplete() {
                if (ServerTracingInterceptor.this.verbose) {
                    span.log("Call completed");
                }
                try (Scope ignored = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, true);){
                    this.delegate().onComplete();
                }
            }
        };
    }

    private Span getSpanFromHeaders(Map<String, String> headers, String operationName) {
        Tracer.SpanBuilder spanBuilder;
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headers));
            spanBuilder = parentSpanCtx == null ? this.tracer.buildSpan(operationName) : this.tracer.buildSpan(operationName).asChildOf(parentSpanCtx);
        }
        catch (IllegalArgumentException iae) {
            spanBuilder = this.tracer.buildSpan(operationName).withTag("Error", "Extract failed and an IllegalArgumentException was thrown");
        }
        return spanBuilder.withTag(Tags.SPAN_KIND.getKey(), "server").withTag(Tags.COMPONENT.getKey(), GrpcTags.COMPONENT_NAME).start();
    }

    public static enum ServerRequestAttribute {
        HEADERS,
        METHOD_TYPE,
        METHOD_NAME,
        CALL_ATTRIBUTES,
        PEER_ADDRESS;

    }

    public static class Builder {
        private final Tracer tracer;
        private OperationNameConstructor operationNameConstructor;
        private boolean streaming;
        private boolean verbose;
        private Set<ServerRequestAttribute> tracedAttributes;
        private ServerSpanDecorator serverSpanDecorator;
        private ServerCloseDecorator serverCloseDecorator;

        public Builder() {
            this(GlobalTracer.get());
        }

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.operationNameConstructor = OperationNameConstructor.DEFAULT;
            this.streaming = false;
            this.verbose = false;
            this.tracedAttributes = new HashSet<ServerRequestAttribute>();
        }

        public Builder withOperationName(OperationNameConstructor operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withTracedAttributes(ServerRequestAttribute ... attributes) {
            this.tracedAttributes = new HashSet<ServerRequestAttribute>(Arrays.asList(attributes));
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public Builder withServerSpanDecorator(ServerSpanDecorator serverSpanDecorator) {
            this.serverSpanDecorator = serverSpanDecorator;
            return this;
        }

        public Builder withServerCloseDecorator(ServerCloseDecorator serverCloseDecorator) {
            this.serverCloseDecorator = serverCloseDecorator;
            return this;
        }

        public ServerTracingInterceptor build() {
            return new ServerTracingInterceptor(this.tracer, this.operationNameConstructor, this.streaming, this.verbose, this.tracedAttributes, this.serverSpanDecorator, this.serverCloseDecorator);
        }
    }
}

