/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.Status;
import io.grpc.inprocess.InProcessSocketAddress;
import io.opentracing.Span;
import io.opentracing.tag.StringTag;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

final class GrpcTags {
    static StringTag GRPC_STATUS = new StringTag("grpc.status");
    static StringTag PEER_ADDRESS = new StringTag("peer.address");
    static String COMPONENT_NAME = "java-grpc";

    private GrpcTags() {
    }

    static void setStatusTags(Span span, Status status) {
        GRPC_STATUS.set(span, status.getCode().name());
    }

    static void setPeerAddressTag(Span span, Attributes attributes) {
        SocketAddress address = (SocketAddress)attributes.get(Grpc.TRANSPORT_ATTR_REMOTE_ADDR);
        if (address instanceof InProcessSocketAddress) {
            PEER_ADDRESS.set(span, ((InProcessSocketAddress)address).getName());
        } else if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            PEER_ADDRESS.set(span, inetAddress.getHostString() + ':' + inetAddress.getPort());
        }
    }
}

