/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.collect.ImmutableMap;
import io.grpc.BindableService;
import io.grpc.Context;
import io.grpc.Contexts;
import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.grpc.OpenTracingContextKey;
import io.opentracing.contrib.grpc.OperationNameConstructor;
import io.opentracing.contrib.grpc.ServerSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapExtractAdapter;
import io.opentracing.util.GlobalTracer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ServerTracingInterceptor
implements ServerInterceptor {
    private final Tracer tracer;
    private final OperationNameConstructor operationNameConstructor;
    private final boolean streaming;
    private final boolean verbose;
    private final Set<ServerRequestAttribute> tracedAttributes;
    private final ServerSpanDecorator serverSpanDecorator;

    public ServerTracingInterceptor() {
        this(GlobalTracer.get());
    }

    public ServerTracingInterceptor(Tracer tracer) {
        this.tracer = tracer;
        this.operationNameConstructor = OperationNameConstructor.DEFAULT;
        this.streaming = false;
        this.verbose = false;
        this.tracedAttributes = new HashSet<ServerRequestAttribute>();
        this.serverSpanDecorator = new NoopServerSpanDecorator();
    }

    private ServerTracingInterceptor(Tracer tracer, OperationNameConstructor operationNameConstructor, boolean streaming, boolean verbose, Set<ServerRequestAttribute> tracedAttributes, ServerSpanDecorator serverSpanDecorator) {
        this.tracer = tracer;
        this.operationNameConstructor = operationNameConstructor;
        this.streaming = streaming;
        this.verbose = verbose;
        this.tracedAttributes = tracedAttributes;
        this.serverSpanDecorator = serverSpanDecorator;
    }

    public ServerServiceDefinition intercept(ServerServiceDefinition serviceDef) {
        return ServerInterceptors.intercept((ServerServiceDefinition)serviceDef, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public ServerServiceDefinition intercept(BindableService bindableService) {
        return ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this});
    }

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        for (String key : headers.keys()) {
            if (key.endsWith("-bin")) continue;
            String value = (String)headers.get(Metadata.Key.of((String)key, (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
            headerMap.put(key, value);
        }
        String operationName = this.operationNameConstructor.constructOperationName(call.getMethodDescriptor());
        final Span span = this.getSpanFromHeaders(headerMap, operationName);
        this.serverSpanDecorator.interceptCall(span, call, headers);
        for (ServerRequestAttribute attr : this.tracedAttributes) {
            switch (attr) {
                case METHOD_TYPE: {
                    span.setTag("grpc.method_type", call.getMethodDescriptor().getType().toString());
                    break;
                }
                case METHOD_NAME: {
                    span.setTag("grpc.method_name", call.getMethodDescriptor().getFullMethodName());
                    break;
                }
                case CALL_ATTRIBUTES: {
                    span.setTag("grpc.call_attributes", call.getAttributes().toString());
                    break;
                }
                case HEADERS: {
                    span.setTag("grpc.headers", headers.toString());
                }
            }
        }
        Context ctxWithSpan = Context.current().withValue(OpenTracingContextKey.getKey(), (Object)span).withValue(OpenTracingContextKey.getSpanContextKey(), (Object)span.context());
        ServerCall.Listener listenerWithContext = Contexts.interceptCall((Context)ctxWithSpan, call, (Metadata)headers, next);
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(listenerWithContext){

            public void onMessage(ReqT message) {
                if (ServerTracingInterceptor.this.streaming || ServerTracingInterceptor.this.verbose) {
                    span.log((Map)ImmutableMap.of((Object)"Message received", message));
                }
                Scope scope = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, false);
                try {
                    this.delegate().onMessage(message);
                }
                finally {
                    scope.close();
                }
            }

            public void onHalfClose() {
                if (ServerTracingInterceptor.this.streaming) {
                    span.log("Client finished sending messages");
                }
                Scope scope = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, false);
                try {
                    this.delegate().onHalfClose();
                }
                finally {
                    scope.close();
                }
            }

            public void onCancel() {
                Scope scope = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, true);
                span.log("Call cancelled");
                try {
                    this.delegate().onCancel();
                }
                finally {
                    scope.close();
                }
            }

            public void onComplete() {
                if (ServerTracingInterceptor.this.verbose) {
                    span.log("Call completed");
                }
                Scope scope = ServerTracingInterceptor.this.tracer.scopeManager().activate(span, true);
                try {
                    this.delegate().onComplete();
                }
                finally {
                    scope.close();
                }
            }
        };
    }

    private Span getSpanFromHeaders(Map<String, String> headers, String operationName) {
        Span span;
        try {
            SpanContext parentSpanCtx = this.tracer.extract(Format.Builtin.HTTP_HEADERS, (Object)new TextMapExtractAdapter(headers));
            span = parentSpanCtx == null ? this.tracer.buildSpan(operationName).start() : this.tracer.buildSpan(operationName).asChildOf(parentSpanCtx).start();
        }
        catch (IllegalArgumentException iae) {
            span = this.tracer.buildSpan(operationName).withTag("Error", "Extract failed and an IllegalArgumentException was thrown").start();
        }
        return span;
    }

    private static class NoopServerSpanDecorator
    implements ServerSpanDecorator {
        private NoopServerSpanDecorator() {
        }

        @Override
        public void interceptCall(Span span, ServerCall call, Metadata headers) {
        }
    }

    public static enum ServerRequestAttribute {
        HEADERS,
        METHOD_TYPE,
        METHOD_NAME,
        CALL_ATTRIBUTES;

    }

    public static class Builder {
        private final Tracer tracer;
        private OperationNameConstructor operationNameConstructor;
        private boolean streaming;
        private boolean verbose;
        private Set<ServerRequestAttribute> tracedAttributes;
        private ServerSpanDecorator serverSpanDecorator;

        public Builder() {
            this(GlobalTracer.get());
        }

        public Builder(Tracer tracer) {
            this.tracer = tracer;
            this.operationNameConstructor = OperationNameConstructor.DEFAULT;
            this.streaming = false;
            this.verbose = false;
            this.tracedAttributes = new HashSet<ServerRequestAttribute>();
            this.serverSpanDecorator = new NoopServerSpanDecorator();
        }

        public Builder withOperationName(OperationNameConstructor operationNameConstructor) {
            this.operationNameConstructor = operationNameConstructor;
            return this;
        }

        public Builder withTracedAttributes(ServerRequestAttribute ... attributes) {
            this.tracedAttributes = new HashSet<ServerRequestAttribute>(Arrays.asList(attributes));
            return this;
        }

        public Builder withStreaming() {
            this.streaming = true;
            return this;
        }

        public Builder withVerbosity() {
            this.verbose = true;
            return this;
        }

        public Builder withServerSpanDecorator(ServerSpanDecorator serverSpanDecorator) {
            this.serverSpanDecorator = serverSpanDecorator;
            return this;
        }

        public ServerTracingInterceptor build() {
            return new ServerTracingInterceptor(this.tracer, this.operationNameConstructor, this.streaming, this.verbose, this.tracedAttributes, this.serverSpanDecorator);
        }
    }
}

