/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.grpc;

import com.google.common.collect.ImmutableMap;
import io.opentracing.Span;
import java.util.Map;

final class GrpcFields {
    static final String ERROR = "error";
    static final String HEADERS = "headers";
    static final String CLIENT_CALL_START = "client-call-start";
    static final String CLIENT_CALL_CANCEL = "client-call-cancel";
    static final String CLIENT_CALL_HALF_CLOSE = "client-call-half-close";
    static final String CLIENT_CALL_SEND_MESSAGE = "client-call-send-message";
    static final String CLIENT_CALL_LISTENER_ON_HEADERS = "client-call-listener-on-headers";
    static final String CLIENT_CALL_LISTENER_ON_MESSAGE = "client-call-listener-on-message";
    static final String CLIENT_CALL_LISTENER_ON_CLOSE = "client-call-listener-on-close";
    static final String SERVER_CALL_SEND_HEADERS = "server-call-send-headers";
    static final String SERVER_CALL_SEND_MESSAGE = "server-call-send-message";
    static final String SERVER_CALL_CLOSE = "server-call-close";
    static final String SERVER_CALL_LISTENER_ON_MESSAGE = "server-call-listener-on-message";
    static final String SERVER_CALL_LISTENER_ON_HALF_CLOSE = "server-call-listener-on-half-close";
    static final String SERVER_CALL_LISTENER_ON_CANCEL = "server-call-listener-on-cancel";
    static final String SERVER_CALL_LISTENER_ON_COMPLETE = "server-call-listener-on-complete";

    GrpcFields() {
    }

    static void logClientCallError(Span span, String message, Throwable cause) {
        GrpcFields.logCallError(span, message, cause, "Client");
    }

    static void logServerCallError(Span span, String message, Throwable cause) {
        GrpcFields.logCallError(span, message, cause, "Server");
    }

    private static void logCallError(Span span, String message, Throwable cause, String name) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"event", (Object)ERROR);
        String causeMessage = null;
        if (cause != null) {
            builder.put((Object)"error.object", (Object)cause);
            causeMessage = cause.getMessage();
        }
        if (message != null) {
            builder.put((Object)"message", (Object)message);
        } else if (causeMessage != null) {
            builder.put((Object)"message", (Object)causeMessage);
        } else {
            builder.put((Object)"message", (Object)(name + " call failed"));
        }
        span.log((Map)builder.build());
    }
}

